/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.WebElement;

import com.vaadin.testbench.By;
import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.Slider")
public class SliderElement extends AbstractFieldElement {
    /**
     * Get value of the slider
     *
     * Warning! This method cause slider popup to appear on the screen. To hide
     * this popup just focus any other element on the page.
     */
    public String getValue() {
        WebElement popupElem = findElement(By.vaadin("#popup"));
        return popupElem.getAttribute("textContent");

    }

    public WebElement getHandle() {
        return findElement(By.className("v-slider-handle"));
    }
}
