/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import com.vaadin.testbench.elementsbase.ServerClass;

/**
 * Element class for testing InlineDateField.
 */
@ServerClass("com.vaadin.ui.InlineDateField")
public class InlineDateFieldElement extends AbstractFieldElement {

    /**
     * Returns the element which receives focus when the component is focused.
     *
     * @return the element which receives focus when the component is focused
     * @since 8.1.1
     */
    public WebElement getFocusElement() {
        return findElement(By.tagName("table"));

    }
}
