/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.GridLayout")
public class GridLayoutElement extends AbstractLayoutElement {
    /**
     * Gets the total number of rows in the layout.
     *
     * @return the number of rows in the layout
     * @since 8.0.6
     */
    public long getRowCount() {
        Long res = (Long) getCommandExecutor()
                .executeScript("return arguments[0].getRowCount()", this);
        if (res == null) {
            throw new IllegalStateException("getRowCount returned null");
        }

        return res.longValue();
    }

    /**
     * Gets the total number of columns in the layout.
     *
     * @return the number of columns in the layout
     * @since 8.0.6
     */
    public long getColumnCount() {
        Long res = (Long) getCommandExecutor()
                .executeScript("return arguments[0].getColumnCount()", this);
        if (res == null) {
            throw new IllegalStateException("getColumnCount returned null");
        }

        return res.longValue();
    }

    /**
     * Gets the cell element at the given position.
     *
     * @param row
     *            the row coordinate
     * @param column
     *            the column coordinate
     * @return the cell element at the given position
     * @throws NoSuchElementException
     *             if no cell was found at the given position
     * @since 8.0.6
     */
    public WebElement getCell(int row, int column) {
        WebElement res = (WebElement) getCommandExecutor().executeScript(
                "return arguments[0].getCell(" + row + "," + column + ")",
                this);
        if (res == null) {
            throw new NoSuchElementException(
                    "No cell found at " + row + "," + column);
        }

        return res;

    }
}
