/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.AbstractTextField")
public class AbstractTextFieldElement extends AbstractFieldElement {

    /**
     * Return value of the field element.
     *
     * @return value of the field element
     */
    public String getValue() {
        return findElement(By.tagName("input")).getAttribute("value");
    }

    /**
     * Set value of the field element. This emulates user changing the value by
     * sending the characters to wrapped input element. The characters are
     * followed by Tab key to trigger blur event.
     * <p>
     * <em>Note:</em>Note: If you are using <code>ValueChangeMode.LAZY</codE> or
     * <code>ValueChangeMode.TIMEOUT</code>, value change event is triggered
     * also without field losing focus, and hence use of <code>sendKeys</code>
     * may be better choice in testing.
     *
     * @param chars
     *            new value of the field
     */
    public void setValue(CharSequence chars) throws ReadOnlyException {
        if (isReadOnly()) {
            throw new ReadOnlyException();
        }
        clearElementClientSide(this);
        focus();
        sendKeys(chars);
        sendKeys(Keys.TAB);
    }
}
