/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.elementsbase.ServerClass;

/**
 * A common base element class for all single select components.
 *
 * @since 8.1.1
 */
@ServerClass("com.vaadin.ui.AbstractSingleSelect")
public abstract class AbstractSingleSelectElement
        extends AbstractSelectElement {

    /**
     * Selects the first option in this single select component that matches the
     * given text.
     *
     * @param text
     *            the text to select by
     */
    public abstract void selectByText(String text);

    /**
     * Return value of this single select component.
     * <p>
     * <strong>Note:</strong> If there is no value selected the behavior of
     * subclasses varies. Pay attention on the actual implementation.
     *
     * @return the value
     */
    public abstract String getValue();
}
