/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.AbstractField")
public class AbstractFieldElement extends AbstractComponentElement {

    /**
     * Select contents of TextField Element.
     *
     * NOTE: When testing with firefox browser window should have focus in it
     *
     * @since 8.0
     * @param elem
     *            element which context will be select
     */
    protected void clientSelectElement(WebElement elem) {
        JavascriptExecutor js = (JavascriptExecutor) getDriver();
        String script = "window.focus();" + "var elem=arguments[0];"
                + "elem.select();elem.focus();";
        js.executeScript(script, elem);
    }

    protected void clearElementClientSide(WebElement elem) {
        // clears without triggering an event (on client side)
        JavascriptExecutor js = (JavascriptExecutor) getDriver();
        String script = "window.focus(); var elem=arguments[0];"
                + "elem.value=\"\";";
        js.executeScript(script, elem);
    }

}
