/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractSelectElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

@ServerClass(value="com.vaadin.ui.TwinColSelect")
public class TwinColSelectElement
extends AbstractSelectElement {
    private Select options;
    private Select selectedOptions;
    private WebElement deselButton;
    private WebElement selButton;
    private static org.openqa.selenium.By bySelect = By.tagName((String)"select");
    private static org.openqa.selenium.By byButton = By.className((String)"v-button");
    private WebElement optionsElement;
    private WebElement selectionsElement;

    protected void init() {
        super.init();
        List selectElements = this.findElements(bySelect);
        this.optionsElement = (WebElement)selectElements.get(0);
        this.selectionsElement = (WebElement)selectElements.get(1);
        this.options = new Select(this.optionsElement);
        this.selectedOptions = new Select(this.selectionsElement);
        List buttons = this.findElements(byButton);
        this.selButton = (WebElement)buttons.get(0);
        this.deselButton = (WebElement)buttons.get(1);
    }

    private void deselectAll() {
        if (this.selectedOptions.isMultiple()) {
            if (this.selectedOptions.getAllSelectedOptions().size() != this.selectedOptions.getOptions().size()) {
                int l = this.selectedOptions.getOptions().size();
                for (int i = 0; i < l; ++i) {
                    this.selectedOptions.selectByIndex(i);
                }
            }
            this.deselButton.click();
        }
        while (!this.selectedOptions.getOptions().isEmpty()) {
            this.selectedOptions.selectByIndex(0);
            this.deselButton.click();
        }
    }

    public void deselectByText(String text) {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException(this);
        }
        this.selectedOptions.deselectAll();
        this.selectedOptions.selectByVisibleText(text);
        this.deselButton.click();
    }

    public List<String> getValues() {
        return this.getOptionsFromSelect(this.selectedOptions);
    }

    public List<String> getOptions() {
        List<String> optionTexts = this.getOptionsFromSelect(this.options);
        optionTexts.addAll(this.getValues());
        return optionTexts;
    }

    public List<String> getAvailableOptions() {
        return this.getOptionsFromSelect(this.options);
    }

    public void selectByText(String text) {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException(this);
        }
        this.options.deselectAll();
        this.options.selectByVisibleText(text);
        this.selButton.click();
    }

    private List<String> getOptionsFromSelect(Select select) {
        ArrayList<String> optionTexts = new ArrayList<String>();
        for (WebElement option : select.getOptions()) {
            optionTexts.add(option.getText());
        }
        return optionTexts;
    }

    public String getValue() {
        String value = "";
        WebElement selectedElement = this.findElement(By.className((String)"v-select-twincol-selections"));
        List optionElements = selectedElement.findElements(By.tagName((String)"option"));
        if (!optionElements.isEmpty()) {
            value = ((WebElement)optionElements.get(0)).getText();
        }
        return value;
    }

    @Override
    public void clear() {
        this.deselectAll();
    }

    public WebElement getOptionsElement() {
        return this.optionsElement;
    }

    public WebElement getSelectionsElement() {
        return this.selectionsElement;
    }
}

