/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elements.AbstractSelectElement;
import com.vaadin.testbench.elements.TableHeaderElement;
import com.vaadin.testbench.elements.TableRowElement;
import com.vaadin.testbench.elementsbase.AbstractElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

@ServerClass(value="com.vaadin.ui.Table")
@Deprecated
public class TableElement
extends AbstractSelectElement {
    public TestBenchElement getCell(int row, int column) {
        TestBenchElement cell = TableElement.wrapElement((WebElement)this.findElement(By.vaadin((String)("#row[" + row + "]/col[" + column + "]"))), (TestBenchCommandExecutor)this.getCommandExecutor());
        return cell;
    }

    public TableRowElement getRow(int row) {
        TestBenchElement rowElem = TableElement.wrapElement((WebElement)this.findElement(By.vaadin((String)("#row[" + row + "]"))), (TestBenchCommandExecutor)this.getCommandExecutor());
        return (TableRowElement)rowElem.wrap(TableRowElement.class);
    }

    public TableHeaderElement getHeaderCell(int column) {
        TestBenchElement headerCell = TableElement.wrapElement((WebElement)this.findElement(By.vaadin((String)("#header[" + column + "]"))), (TestBenchCommandExecutor)this.getCommandExecutor());
        return (TableHeaderElement)headerCell.wrap(TableHeaderElement.class);
    }

    public TestBenchElement getFooterCell(int column) {
        TestBenchElement footerCell = TableElement.wrapElement((WebElement)this.findElement(By.vaadin((String)("#footer[" + column + "]"))), (TestBenchCommandExecutor)this.getCommandExecutor());
        return footerCell;
    }

    public void scroll(int scrollTop) {
        ((TestBenchElement)this.findElement(By.className((String)"v-scrollable"))).scroll(scrollTop);
    }

    public void scrollLeft(int scrollLeft) {
        ((TestBenchElement)this.findElement(By.className((String)"v-scrollable"))).scrollLeft(scrollLeft);
    }

    public void contextClick() {
        WebElement tbody = this.findElement(By.className((String)"v-table-body"));
        new Actions(this.getDriver()).contextClick(tbody).build().perform();
    }

    public ContextMenuElement getContextMenu() {
        try {
            WebElement cm = this.getDriver().findElement(By.className((String)"v-contextmenu"));
            return (ContextMenuElement)TableElement.wrapElement((WebElement)cm, (TestBenchCommandExecutor)this.getCommandExecutor()).wrap(ContextMenuElement.class);
        }
        catch (WebDriverException e) {
            throw new NoSuchElementException("Context menu not found", (Throwable)e);
        }
    }

    public CollapseMenuElement openCollapseMenu() {
        this.getCollapseMenuToggle().click();
        WebElement cm = this.getDriver().findElement(By.xpath((String)"//*[@id='PID_VAADIN_CM']"));
        return (CollapseMenuElement)TableElement.wrapElement((WebElement)cm, (TestBenchCommandExecutor)this.getCommandExecutor()).wrap(CollapseMenuElement.class);
    }

    public WebElement getCollapseMenuToggle() {
        return this.findElement(By.className((String)"v-table-column-selector"));
    }

    public static class CollapseMenuElement
    extends ContextMenuElement {
    }

    public static class ContextMenuElement
    extends AbstractElement {
        public WebElement getItem(int index) {
            return this.findElement(By.xpath((String)(".//table//tr[" + (index + 1) + "]//td/*")));
        }
    }
}

