/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.addon.charts.Chart")
public class ChartElement
extends AbstractComponentElement {
    public WebElement getSvg() {
        return this.findElement(By.tagName((String)"svg"));
    }

    public WebElement getMenuButton() {
        return this.findElement(By.className((String)"highcharts-button"));
    }

    public WebElement getMenuOverlay() {
        return this.findElement(By.className((String)"highcharts-contextmenu"));
    }

    public List<WebElement> getMenuItems() {
        WebElement menu = this.getMenuOverlay().findElement(By.tagName((String)"div"));
        return menu.findElements(By.tagName((String)"div"));
    }

    public List<WebElement> getLegendItems() {
        return this.findElements(By.className((String)"highcharts-legend-item"));
    }

    public List<WebElement> getSeries() {
        return this.findElements(By.className((String)"highcharts-series"));
    }

    public List<String> getYAxisTitles() {
        return this.findElements(By.className((String)"highcharts-yaxis-title")).stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public List<String> getYAxisLabels(int index) {
        List yAxes = this.findElements(By.className((String)"highcharts-yaxis-labels"));
        WebElement labelsContainer = (WebElement)yAxes.get(index);
        List texts = labelsContainer.findElements(By.tagName((String)"text"));
        return texts.stream().map(ChartElement::getLabelText).collect(Collectors.toList());
    }

    public List<String> getXAxisLabels() {
        WebElement labelsContainer = this.findElement(By.className((String)"highcharts-xaxis-labels"));
        List texts = labelsContainer.findElements(By.tagName((String)"text"));
        return texts.stream().map(ChartElement::getLabelText).collect(Collectors.toList());
    }

    protected static String getLabelText(WebElement text) {
        return text.findElements(By.tagName((String)"tspan")).stream().map(WebElement::getText).collect(Collectors.joining(" "));
    }

    public List<String> getDataLabels() {
        return this.findElements(By.className((String)"highcharts-data-labels")).stream().flatMap(dl -> dl.findElements(By.tagName((String)"tspan")).stream()).map(WebElement::getText).collect(Collectors.toList());
    }

    public String getTitle() {
        WebElement title = this.findElement(By.className((String)"highcharts-title"));
        return ChartElement.getLabelText(title);
    }

    public String getSubTitle() {
        WebElement subtitle = this.findElement(By.className((String)"highcharts-subtitle"));
        return ChartElement.getLabelText(subtitle);
    }
}

