/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractSelectElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

@ServerClass(value="com.vaadin.ui.ListSelect")
public class ListSelectElement
extends AbstractSelectElement {
    private Select select;
    private static By bySelect = By.tagName((String)"select");
    private WebElement selectElement;

    protected void init() {
        super.init();
        this.selectElement = this.findElement(bySelect);
        this.select = new Select(this.selectElement);
    }

    public void selectByText(String text) {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException();
        }
        this.select.selectByVisibleText(text);
    }

    public void deselectByText(String text) {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException();
        }
        this.select.deselectByVisibleText(text);
    }

    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        for (WebElement webElement : this.select.getOptions()) {
            options.add(webElement.getText());
        }
        return options;
    }

    @Override
    public void clear() {
        super.clear();
    }

    public String getValue() {
        return this.select.getFirstSelectedOption().getText();
    }

    public WebElement getSelectElement() {
        return this.selectElement;
    }
}

