/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.By;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.HorizontalSplitPanel")
public class HorizontalSplitPanelElement extends AbstractSplitPanelElement {

    private static By bySplit = By.className("v-splitpanel-hsplitter");

    public TestBenchElement getSplitter() {
        return wrapElement(findElement(bySplit), getCommandExecutor());
    }
}
