/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractSingleSelectElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

@ServerClass(value="com.vaadin.ui.NativeSelect")
public class NativeSelectElement
extends AbstractSingleSelectElement {
    private Select select;
    private WebElement selectElement;

    protected void init() {
        super.init();
        this.selectElement = this.findElement(By.tagName((String)"select"));
        this.select = new Select(this.selectElement);
    }

    public WebElement getSelectElement() {
        return this.selectElement;
    }

    public List<TestBenchElement> getOptions() {
        return NativeSelectElement.wrapElements((List)this.select.getOptions(), (TestBenchCommandExecutor)this.getCommandExecutor());
    }

    @Override
    public void selectByText(String text) throws AbstractComponentElement.ReadOnlyException {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException();
        }
        this.select.selectByVisibleText(text);
        this.waitForVaadin();
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String getValue() throws NoSuchElementException {
        return this.select.getFirstSelectedOption().getText();
    }

    public void setValue(CharSequence chars) throws AbstractComponentElement.ReadOnlyException {
        this.selectByText((String)chars);
    }
}

