/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elementsbase.AbstractElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.Grid")
public class GridElement
extends AbstractComponentElement {
    public void scrollToRow(int index) {
        try {
            this.getSubPart("#cell[" + index + "]");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public GridCellElement getCell(int rowIndex, int colIndex) {
        this.scrollToRow(rowIndex);
        return (GridCellElement)this.getSubPart("#cell[" + rowIndex + "][" + colIndex + "]").wrap(GridCellElement.class);
    }

    public GridRowElement getRow(int index) {
        this.scrollToRow(index);
        return (GridRowElement)this.getSubPart("#cell[" + index + "]").wrap(GridRowElement.class);
    }

    public GridCellElement getHeaderCell(int rowIndex, int colIndex) {
        return (GridCellElement)this.getSubPart("#header[" + rowIndex + "][" + colIndex + "]").wrap(GridCellElement.class);
    }

    public GridCellElement getHeaderCellByCaption(String caption) {
        List headerRows = this.findElement(By.vaadin((String)"#header")).findElements(By.xpath((String)"./tr/th"));
        for (WebElement header : headerRows) {
            if (!caption.equals(header.getText())) continue;
            return (GridCellElement)TestBenchElement.wrapElement((WebElement)header, (TestBenchCommandExecutor)this.getCommandExecutor()).wrap(GridCellElement.class);
        }
        String errorMessage = String.format("There is no header cell with %s caption. ", caption);
        throw new NoSuchElementException(errorMessage);
    }

    public GridCellElement getHeaderCellByCaption(int rowIndex, String caption) {
        List<GridCellElement> headerCells = this.getHeaderCells(rowIndex);
        for (GridCellElement cell : headerCells) {
            if (!caption.equals(cell.getText())) continue;
            return cell;
        }
        String errorMessage = String.format("The row with index %d does not have header with %s caption. ", rowIndex, caption);
        throw new NoSuchElementException(errorMessage);
    }

    public GridCellElement getFooterCell(int rowIndex, int colIndex) {
        return (GridCellElement)this.getSubPart("#footer[" + rowIndex + "][" + colIndex + "]").wrap(GridCellElement.class);
    }

    public List<GridCellElement> getHeaderCells(int rowIndex) {
        ArrayList<GridCellElement> headers = new ArrayList<GridCellElement>();
        for (TestBenchElement e : TestBenchElement.wrapElements((List)this.getSubPart("#header[" + rowIndex + "]").findElements(By.xpath((String)"./th")), (TestBenchCommandExecutor)this.getCommandExecutor())) {
            headers.add((GridCellElement)e.wrap(GridCellElement.class));
        }
        return headers;
    }

    public List<GridCellElement> getFooterCells(int rowIndex) {
        ArrayList<GridCellElement> footers = new ArrayList<GridCellElement>();
        for (TestBenchElement e : TestBenchElement.wrapElements((List)this.getSubPart("#footer[" + rowIndex + "]").findElements(By.xpath((String)"./td")), (TestBenchCommandExecutor)this.getCommandExecutor())) {
            footers.add((GridCellElement)e.wrap(GridCellElement.class));
        }
        return footers;
    }

    public int getHeaderCount() {
        return this.getSubPart("#header").findElements(By.xpath((String)"./tr")).size();
    }

    public int getFooterCount() {
        return this.getSubPart("#footer").findElements(By.xpath((String)"./tr")).size();
    }

    public TestBenchElement getHeaderRow(int rowIndex) {
        return this.getSubPart("#header[" + rowIndex + "]");
    }

    public TestBenchElement getFooterRow(int rowIndex) {
        return this.getSubPart("#footer[" + rowIndex + "]");
    }

    public TestBenchElement getVerticalScroller() {
        List rootElements = this.findElements(By.xpath((String)"./div"));
        return (TestBenchElement)rootElements.get(0);
    }

    public TestBenchElement getHorizontalScroller() {
        List rootElements = this.findElements(By.xpath((String)"./div"));
        return (TestBenchElement)rootElements.get(1);
    }

    public TestBenchElement getHeader() {
        return this.getSubPart("#header");
    }

    public TestBenchElement getBody() {
        return this.getSubPart("#cell");
    }

    public TestBenchElement getFooter() {
        return this.getSubPart("#footer");
    }

    public TestBenchElement getTableWrapper() {
        List rootElements = this.findElements(By.xpath((String)"./div"));
        return (TestBenchElement)rootElements.get(2);
    }

    public GridEditorElement getEditor() {
        return ((GridEditorElement)this.getSubPart("#editor").wrap(GridEditorElement.class)).setGrid(this);
    }

    private TestBenchElement getSubPart(String subPartSelector) {
        return (TestBenchElement)this.findElement(By.vaadin((String)subPartSelector));
    }

    public TestBenchElement getDetails(int rowIndex) throws NoSuchElementException {
        return this.getSubPart("#details[" + rowIndex + "]");
    }

    public void toggleColumnHidden(String toggleCaption) {
        Optional<WebElement> toggleButton;
        if (!this.isElementPresent(By.className((String)"v-grid-sidebar-content"))) {
            WebElement sidebarButton = this.findElement(By.className((String)"v-grid-sidebar")).findElement(By.tagName((String)"button"));
            sidebarButton.click();
        }
        if (!(toggleButton = this.getDriver().findElement(By.className((String)"v-grid-sidebar-content")).findElements(By.className((String)"column-hiding-toggle")).stream().filter(element -> element.getText().equals(toggleCaption)).findAny()).isPresent()) {
            throw new IllegalArgumentException("No column hiding toggle with caption '" + toggleCaption + "'");
        }
        toggleButton.ifPresent(element -> element.click());
    }

    public long getRowCount() {
        Long res = (Long)this.getCommandExecutor().executeScript("return arguments[0].getBodyRowCount()", new Object[]{this});
        if (res == null) {
            throw new IllegalStateException("getBodyRowCount returned null");
        }
        return res;
    }

    public Iterable<GridRowElement> getRows() {
        return () -> new Iterator<GridRowElement>(){
            int nextIndex = 0;

            @Override
            public GridRowElement next() {
                return GridElement.this.getRow(this.nextIndex++);
            }

            @Override
            public boolean hasNext() {
                try {
                    GridElement.this.getRow(this.nextIndex);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    public static class GridEditorElement
    extends AbstractElement {
        private GridElement grid;

        private GridEditorElement setGrid(GridElement grid) {
            this.grid = grid;
            return this;
        }

        public TestBenchElement getField(int colIndex) {
            return this.grid.getSubPart("#editor[" + colIndex + "]");
        }

        public boolean isEditable(int colIndex) {
            return this.grid.isElementPresent(By.vaadin((String)("#editor[" + colIndex + "]")));
        }

        public boolean isFieldErrorMarked(int colIndex) {
            return this.getField(colIndex).getAttribute("class").contains("error");
        }

        public void save() {
            this.findElement(By.className((String)"v-grid-editor-save")).click();
        }

        public void cancel() {
            this.findElement(By.className((String)"v-grid-editor-cancel")).click();
        }

        public String getErrorMessage() {
            WebElement messageWrapper = this.findElement(By.className((String)"v-grid-editor-message"));
            List divs = messageWrapper.findElements(By.tagName((String)"div"));
            if (divs.isEmpty()) {
                return null;
            }
            return ((WebElement)divs.get(0)).getText();
        }
    }

    public static class GridRowElement
    extends AbstractElement {
        private static final String FOCUSED_CLASS_NAME = "-row-focused";
        private static final String SELECTED_CLASS_NAME = "-row-selected";

        public boolean isFocused() {
            return this.getAttribute("class").contains(FOCUSED_CLASS_NAME);
        }

        public boolean isSelected() {
            return this.getAttribute("class").contains(SELECTED_CLASS_NAME);
        }

        public GridCellElement getCell(int columnIndex) {
            TestBenchElement e = (TestBenchElement)this.findElement(By.xpath((String)("./td[" + (columnIndex + 1) + "]")));
            return (GridCellElement)e.wrap(GridCellElement.class);
        }
    }

    public static class GridCellElement
    extends AbstractElement {
        private static final String FOCUSED_CELL_CLASS_NAME = "-cell-focused";
        private static final String FROZEN_CLASS_NAME = "frozen";

        public boolean isFocused() {
            return this.getAttribute("class").contains(FOCUSED_CELL_CLASS_NAME);
        }

        public boolean isFrozen() {
            return this.getAttribute("class").contains(FROZEN_CLASS_NAME);
        }
    }
}

