/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.Link")
public class LinkElement extends AbstractComponentElement {

    @Override
    public void click() {
        getAnchor().click();
    }

    private WebElement getAnchor() {
        return findElement(By.tagName("a"));
    }

    @Override
    public String getCaption() {
        return getAnchor().getText();
    }
}
