/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.swingkit.core.EmbeddedBrowserException;
import com.vaadin.swingkit.core.InvocationUtils;
import com.vaadin.swingkit.core.VaadinSwingEvent;
import com.vaadin.swingkit.server.EmbeddedBrowserJSCaller;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventEmitter
implements EmbeddedBrowserJSCaller {
    private static final Logger log = LoggerFactory.getLogger(EventEmitter.class);
    String encodedEvent;

    public void emit(VaadinSwingEvent event) throws EmbeddedBrowserException {
        try {
            this.encodedEvent = InvocationUtils.encode((Object)event);
        }
        catch (Exception e) {
            log.error("Error decoding Event", (Throwable)e);
        }
        try {
            this.checkContext().then((SerializableConsumer & Serializable)result -> {
                if (result.asBoolean()) {
                    log.info("Fired Vaadin2Swing Event through " + this.getBrowserName() + " function");
                    this.executeQuery();
                } else {
                    String errorMessage = "No Swing " + this.getBrowserName() + " context available.";
                    log.error(errorMessage);
                }
            });
        }
        catch (Exception e) {
            String errorMessage = "Error emitting Event, check Swing " + this.getBrowserName() + " context available";
            log.error(errorMessage, (Throwable)e);
            throw new EmbeddedBrowserException(errorMessage);
        }
    }

    protected PendingJavaScriptResult checkContext() {
        return UI.getCurrent().getPage().executeJs(this.getCheckDefinedJS(), new Object[0]);
    }

    protected PendingJavaScriptResult executeQuery() {
        return UI.getCurrent().getPage().executeJs(this.getQueryJS(), new Object[0]);
    }
}

