/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.server;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.page.Page;
import com.vaadin.swingkit.core.EmbeddedBrowserException;
import com.vaadin.swingkit.core.HandledInvocations;
import com.vaadin.swingkit.core.InvocationUtils;
import com.vaadin.swingkit.core.MethodInvocation;
import com.vaadin.swingkit.core.VaadinSwingEvent;
import com.vaadin.swingkit.server.EventEmitter;
import com.vaadin.swingkit.server.EventEmitterFactory;
import com.vaadin.swingkit.server.SwingResponseBuilder;
import com.vaadin.swingkit.server.SwingVaadinServer;
import com.vaadin.swingkit.server.VaadinHandledInvocations;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="swing-bridge")
@JsModule(value="./vaadin-bridge.ts")
public class SwingBridge
extends LitTemplate {
    private final Logger log = LoggerFactory.getLogger(SwingBridge.class);
    private final HandledInvocations invocations = new VaadinHandledInvocations();
    private final SwingResponseBuilder responseBuilder = SwingVaadinServer.isSwingRendered() ? new SwingResponseBuilder() : null;

    SwingBridge() {
        this.setup();
    }

    private void setup() {
        this.invocations.register("javax.swing.JComponent", "void", "setEnabled", new String[]{"boolean"}, invocation -> {
            this.log.debug("Invoking: " + String.valueOf(invocation));
            List cc = UI.getCurrent().getInternals().getActiveRouterTargetsChain();
            for (HasElement c : cc) {
                if (!(c instanceof HasEnabled)) continue;
                ((HasEnabled)c).setEnabled(((Boolean)invocation.getArgValues()[0]).booleanValue());
                break;
            }
            return null;
        });
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (SwingVaadinServer.isSwingRendered()) {
            EventEmitter emitter = EventEmitterFactory.newEventEmitter();
            emitter.emit(new VaadinSwingEvent("attach-bridge"));
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (SwingVaadinServer.isSwingRendered()) {
            EventEmitter emitter = EventEmitterFactory.newEventEmitter();
            emitter.emit(new VaadinSwingEvent("detach-bridge"));
        }
    }

    @ClientCallable
    public void invoke(String invocation) {
        Page page = UI.getCurrent().getPage();
        try {
            MethodInvocation mi = (MethodInvocation)InvocationUtils.decode((String)invocation);
            this.log.info("Recieved method invocation: {}", (Object)mi);
            String responseJs = this.responseBuilder.origin(mi).result(this.invocations.invoke(mi)).buildJS();
            this.log.info("Sending response " + responseJs);
            page.executeJs(responseJs, new Object[0]);
        }
        catch (EmbeddedBrowserException ex) {
            this.log.error("No valid Embedded Browser detected", (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.error("Error invoking method in swing bridge.", (Throwable)ex);
        }
    }

    @ClientCallable
    public String ping() {
        this.log.info("Pong");
        return "Pong";
    }
}

