/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.swingkit.core.SwingVaadinConsts;
import com.vaadin.swingkit.core.VaadinSwingEventBuilder;
import com.vaadin.swingkit.server.Bridge;
import com.vaadin.swingkit.server.EventEmitter;
import com.vaadin.swingkit.server.EventEmitterFactory;
import com.vaadin.swingkit.server.LicenseHelper;
import com.vaadin.swingkit.server.NoEmbeddedBrowserException;
import com.vaadin.swingkit.server.SwingBridge;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.springframework.stereotype.Component
public class SwingServiceInitListener
implements VaadinServiceInitListener,
ErrorHandler {
    private final Logger log = LoggerFactory.getLogger(SwingServiceInitListener.class);

    public void serviceInit(ServiceInitEvent event) {
        LicenseHelper.checkLicense();
        event.getSource().addUIInitListener((UIInitListener & Serializable)initEvent -> {
            this.log.info("A new UI has been initialized! {}", (Object)initEvent.getUI().getElement());
            UI ui = initEvent.getUI();
            ui.addBeforeEnterListener((BeforeEnterListener & Serializable)beforeEnterEvent -> {
                ui.getChildren().filter(c -> c instanceof SwingBridge).findFirst().ifPresent(xva$0 -> ui.remove(new Component[]{xva$0}));
                if (beforeEnterEvent.getNavigationTarget().isAnnotationPresent(Bridge.class)) {
                    boolean isSwingRendered;
                    ui.add(new Component[]{new SwingBridge()});
                    SwingVaadinConsts.UserAgent userAgent = SwingVaadinConsts.UserAgent.getFromName((String)SwingServiceInitListener.getBrowserApplication());
                    boolean bl = isSwingRendered = userAgent != null;
                    if (isSwingRendered) {
                        ui.getSession().setErrorHandler((ErrorHandler)this);
                    }
                }
            });
        });
    }

    public void error(ErrorEvent event) {
        if (UI.getCurrent() == null) {
            this.log.error("No UI instance available to send error event information to swing.");
            return;
        }
        this.log.error("Sending exception to Swing.", event.getThrowable());
        try {
            EventEmitter actionEmitter = EventEmitterFactory.newEventEmitter();
            VaadinSwingEventBuilder eventBuilder = new VaadinSwingEventBuilder("exception");
            eventBuilder.addParam("content", (Serializable)((Object)event.getThrowable().getClass().getCanonicalName()));
            actionEmitter.emit(eventBuilder.build());
        }
        catch (NoEmbeddedBrowserException e) {
            this.log.error("Failed to send exception to Swing app. No embedded browser detected.");
        }
    }

    static String getBrowserApplication() {
        return UI.getCurrent().getSession().getBrowser().getBrowserApplication();
    }
}

