/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.server;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LicenseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseHelper.class);

    private LicenseHelper() {
    }

    static void checkLicense() {
        boolean isProductionMode;
        VaadinService vaadinService = VaadinService.getCurrent();
        if (vaadinService != null && !(isProductionMode = vaadinService.getDeploymentConfiguration().isProductionMode())) {
            try (InputStream propertiesStream = vaadinService.getClassLoader().getResourceAsStream("swing-kit.properties");){
                Properties properties = new Properties();
                properties.load(propertiesStream);
                String productName = properties.getProperty("cvdlName");
                String productVersion = properties.getProperty("version");
                LicenseChecker.checkLicenseFromStaticBlock((String)productName, (String)productVersion, (BuildType)BuildType.DEVELOPMENT);
            }
            catch (IOException e) {
                LOG.warn("License not checked due to an error reading properties file.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

