/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.server;

import com.vaadin.flow.component.UI;
import com.vaadin.swingkit.core.EmbeddedBrowserException;
import com.vaadin.swingkit.core.InvocationResponse;
import com.vaadin.swingkit.core.InvocationUtils;
import com.vaadin.swingkit.core.MethodInvocation;
import com.vaadin.swingkit.core.SwingVaadinConsts;
import com.vaadin.swingkit.server.JCefSwingJavascriptResponse;
import com.vaadin.swingkit.server.JxBrowserSwingJavascriptResponse;
import com.vaadin.swingkit.server.NoEmbeddedBrowserException;
import com.vaadin.swingkit.server.SwingJavascriptResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwingResponseBuilder {
    private final Logger log = LoggerFactory.getLogger(SwingResponseBuilder.class);
    private MethodInvocation origin;
    private Object result;
    private final SwingVaadinConsts.UserAgent userAgent;
    private final SwingJavascriptResponse response;

    SwingResponseBuilder() {
        this(null, null);
    }

    SwingResponseBuilder(MethodInvocation origin, Object result) throws NoEmbeddedBrowserException {
        this.origin = origin;
        this.result = result;
        this.userAgent = SwingVaadinConsts.UserAgent.getFromName((String)SwingResponseBuilder.getBrowserApplication());
        if (this.userAgent == null) {
            throw new NoEmbeddedBrowserException();
        }
        this.log.info("User Agent " + this.userAgent.getName());
        if (this.userAgent.equals((Object)SwingVaadinConsts.UserAgent.JCEFBROWSER_AGENT)) {
            this.response = new JCefSwingJavascriptResponse();
        } else if (this.userAgent.equals((Object)SwingVaadinConsts.UserAgent.JXBROWSER_AGENT)) {
            this.response = new JxBrowserSwingJavascriptResponse();
        } else {
            throw new NoEmbeddedBrowserException();
        }
    }

    SwingResponseBuilder origin(MethodInvocation origin) {
        this.origin = origin;
        return this;
    }

    SwingResponseBuilder result(Object result) {
        this.result = result;
        return this;
    }

    String buildJS() throws EmbeddedBrowserException, IOException {
        if (this.origin == null) {
            throw new IllegalStateException("Cannot build JS call without an origin value.");
        }
        InvocationResponse ir = new InvocationResponse();
        ir.setId(this.origin.getId());
        ir.setClassType(this.origin.getMethodDescription().getReturnType());
        ir.setData(this.result);
        this.log.trace("Built response {}", (Object)ir);
        String encodedResponse = InvocationUtils.encode((Object)ir);
        this.log.debug("User Agent {}", (Object)this.userAgent.getName());
        return this.getReponseJS(encodedResponse);
    }

    MethodInvocation getOrigin() {
        return this.origin;
    }

    Object getResult() {
        return this.result;
    }

    SwingJavascriptResponse getResponse() {
        return this.response;
    }

    static String getBrowserApplication() {
        return UI.getCurrent().getSession().getBrowser().getBrowserApplication();
    }

    String getReponseJS(String encodedResponse) {
        return this.response.generateResponseJS(encodedResponse);
    }
}

