/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.swingkit.core.EmbeddedBrowserException;
import com.vaadin.swingkit.server.EmbeddedBrowserJSCaller;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SwingJavascriptResponse
implements EmbeddedBrowserJSCaller {
    private static final Logger log = LoggerFactory.getLogger(SwingJavascriptResponse.class);
    String encodedResponse;

    public String generateResponseJS(String encodedResponse) throws EmbeddedBrowserException {
        this.encodedResponse = encodedResponse;
        this.checkContext().then((SerializableConsumer & Serializable)result -> {
            if (!result.asBoolean()) {
                String errorMessage = "No Swing " + this.getBrowserName() + " context available.";
                log.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            log.info("Fired Vaadin2Swing Syncronized Response through " + this.getBrowserName() + " function");
        });
        return this.getQueryJS();
    }

    protected PendingJavaScriptResult checkContext() {
        return UI.getCurrent().getPage().executeJs(this.getCheckDefinedJS(), new Serializable[0]);
    }
}

