/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.server;

import com.vaadin.flow.component.UI;
import com.vaadin.swingkit.core.HandledInvocations;
import com.vaadin.swingkit.core.MethodDescription;
import com.vaadin.swingkit.core.MethodInvocation;
import com.vaadin.swingkit.core.SwingVaadinCallable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VaadinHandledInvocations
extends HandledInvocations {
    private final Logger log = LoggerFactory.getLogger(VaadinHandledInvocations.class);
    private final HashMap<String, SwingVaadinCallable> swingCallableInstanceCache = new HashMap();

    public Object invoke(MethodInvocation methodInvocation) throws IOException, ClassNotFoundException {
        Object result = null;
        if (this.isHandled(methodInvocation)) {
            result = super.invoke(methodInvocation);
        } else {
            Optional<SwingVaadinCallable> swc = this.searchForInterface(methodInvocation.getMethodDescription());
            if (swc.isPresent()) {
                Method swcMethod = null;
                try {
                    swcMethod = this.descriptionToMethod(methodInvocation.getMethodDescription(), swc.get().getClass().getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    this.log.warn("Unable to find the requested SwingVaadinCallable interface", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    this.log.warn("Unable to find the SwingVaadinCallable method requested", (Throwable)e);
                }
                if (swcMethod != null) {
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Invoking {}[{}] over {} ({}[{}])", new Object[]{swcMethod, swcMethod.getDeclaringClass().getClassLoader(), swc, swc.get().getClass(), swc.get().getClass().getClassLoader()});
                        }
                        return swcMethod.invoke((Object)swc.get(), methodInvocation.getArgValues());
                    }
                    catch (InvocationTargetException e) {
                        this.log.warn("Handled exception thrown by handled invocation.", (Throwable)e);
                        return e.getTargetException() == null ? e : e.getTargetException();
                    }
                    catch (Exception e) {
                        this.log.error("Non handled thrown by handled invocation.", (Throwable)e);
                        return e;
                    }
                }
            }
        }
        return result;
    }

    private Optional<SwingVaadinCallable> searchForInterface(MethodDescription methodInvocation) {
        String className = methodInvocation.getClassName();
        if (!this.swingCallableInstanceCache.containsKey(className)) {
            Optional<Object> applicableComponent = Optional.empty();
            try {
                applicableComponent = UI.getCurrent().getChildren().filter(c -> {
                    Class<?> swingInterfaceName = null;
                    boolean isAssignable = false;
                    try {
                        swingInterfaceName = Class.forName(className, true, c.getClass().getClassLoader());
                        isAssignable = swingInterfaceName.isAssignableFrom(c.getClass());
                    }
                    catch (ClassNotFoundException e) {
                        this.log.error("Class {} not found in {}", (Object)className, (Object)e.getClass().getClassLoader());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Is {} assignable to {}? -> {}", new Object[]{swingInterfaceName.getName(), c.getClass().getName(), isAssignable});
                        this.log.debug("Is {} assignable to {}? -> {}", new Object[]{swingInterfaceName.getClassLoader(), c.getClass().getClassLoader(), isAssignable});
                    }
                    return isAssignable;
                }).findFirst();
            }
            catch (Exception e) {
                this.log.warn("An unknown error happened when retrieving the remove swing/vaadin interface: " + className, (Throwable)e);
            }
            if (applicableComponent.isEmpty()) {
                this.log.warn("Cannot find an implementation of a SwingVaadinCallable in the current UI");
            } else {
                this.swingCallableInstanceCache.put(className, (SwingVaadinCallable)applicableComponent.get());
            }
        }
        return Optional.ofNullable(this.swingCallableInstanceCache.get(className));
    }
}

