/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.core;

import com.vaadin.swingkit.core.MethodDescription;
import com.vaadin.swingkit.core.MethodInvocation;
import com.vaadin.swingkit.core.SwingVaadinInvocation;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;

public class HandledInvocations {
    private final HashMap<MethodDescription, SwingVaadinInvocation<?>> registrations;
    private final HashMap<MethodDescription, Method> methodCache = new HashMap();

    public HandledInvocations() {
        this.registrations = new HashMap();
    }

    public void register(MethodDescription description, SwingVaadinInvocation<?> runner) {
        this.registrations.put(description, runner);
    }

    public void register(String className, String returnType, String methodName, String[] argTypes, SwingVaadinInvocation<?> runner) {
        MethodDescription description = new MethodDescription();
        description.setClassName(className);
        description.setMethodName(methodName);
        description.setReturnType(returnType);
        description.setArgTypes(argTypes);
        this.register(description, runner);
    }

    public Object invoke(MethodInvocation methodInvocation) throws ClassNotFoundException, IOException {
        if (this.isHandled(methodInvocation)) {
            return this.registrations.get(methodInvocation.getMethodDescription()).invoke(methodInvocation);
        }
        return null;
    }

    public boolean isHandled(MethodInvocation methodInvocation) {
        return this.registrations.containsKey(methodInvocation.getMethodDescription());
    }

    protected Method descriptionToMethod(MethodDescription desc, ClassLoader cl) throws ClassNotFoundException, NoSuchMethodException {
        if (!this.methodCache.containsKey(desc)) {
            this.methodCache.put(desc, Class.forName(desc.getClassName(), true, cl).getMethod(desc.getMethodName(), (Class[])Arrays.stream(desc.getArgTypes()).map(argClassName -> {
                try {
                    return Class.forName(argClassName, true, cl);
                }
                catch (ClassNotFoundException e) {
                    return Object.class;
                }
            }).toArray(Class[]::new)));
        }
        return this.methodCache.get(desc);
    }

    public MethodDescription[] getHandledInvocations() {
        return this.registrations.keySet().toArray(new MethodDescription[0]);
    }
}

