/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.core;

import com.vaadin.swingkit.core.MethodDescription;
import com.vaadin.swingkit.core.MethodInvocation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;

public class InvocationUtils {
    private InvocationUtils() {
    }

    public static String encode(Object methodInvocation) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(methodInvocation);
        oos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    public static String encode(Method method, Object[] args) throws IOException {
        return InvocationUtils.encode(InvocationUtils.create(method, args));
    }

    public static MethodInvocation create(Method method, Object[] args) {
        MethodInvocation mi = new MethodInvocation();
        mi.setArgValues(args);
        MethodDescription md = new MethodDescription();
        md.setMethodName(method.getName());
        md.setClassName(method.getDeclaringClass().getName());
        md.setReturnType(method.getReturnType().getName());
        md.setArgTypes((String[])Arrays.stream(method.getParameterTypes()).map(Class::getName).toArray(String[]::new));
        mi.setMethodDescription(md);
        mi.setId(UUID.randomUUID().toString());
        return mi;
    }

    public static <E> E decode(String encodedMethodInvocation) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(encodedMethodInvocation);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return (E)o;
    }
}

