/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.client.jcef;

import com.vaadin.swingkit.client.JVaadinPanel;
import com.vaadin.swingkit.client.jcef.JCefJVaadinPanel;
import com.vaadin.swingkit.core.SwingKitException;
import com.vaadin.swingkit.core.VaadinSwingEvent;
import com.vaadin.swingkit.core.VaadinSwingEventBuilder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VaadinJCefLoadHandler
extends CefLoadHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(VaadinJCefLoadHandler.class);
    private final Map<CefBrowser, JVaadinPanel> lookup = new HashMap<CefBrowser, JVaadinPanel>();

    VaadinJCefLoadHandler() {
    }

    public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
        this.log.error("Error Loading URL " + failedUrl + " - " + errorText + ": " + errorCode.getCode());
        JVaadinPanel panel = this.lookup.get(browser);
        if (panel == null) {
            this.log.error("An error was received from a CefBrowser, however, could not find panel in lookup table");
            return;
        }
        if (!panel.isVisible()) {
            this.log.trace("Error from an invisible panel, listeners were not notified.");
            return;
        }
        SwingUtilities.invokeLater(() -> {
            VaadinSwingEventBuilder eventBuilder = new VaadinSwingEventBuilder("exception");
            eventBuilder.addParam("content", (Serializable)((Object)String.format("Error loading URL %s - %s: %d", failedUrl, errorText, errorCode.getCode())));
            eventBuilder.addParam("type", (Serializable)SwingKitException.NETWORK_EXCEPTION);
            VaadinSwingEvent exceptionEvent = eventBuilder.build();
            panel.fireEvent(exceptionEvent);
        });
    }

    public void addPanel(CefBrowser browser, JCefJVaadinPanel panel) {
        this.lookup.put(browser, panel);
    }
}

