/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.client.jcef;

import com.vaadin.swingkit.client.JVaadinPanel;
import com.vaadin.swingkit.client.jcef.JCefJVaadinPanel;
import com.vaadin.swingkit.core.InvocationUtils;
import com.vaadin.swingkit.core.VaadinSwingEvent;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VaadinJCefEventNotifier
extends CefMessageRouterHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(VaadinJCefEventNotifier.class);
    private final Map<CefBrowser, JVaadinPanel> lookup = new HashMap<CefBrowser, JVaadinPanel>();

    VaadinJCefEventNotifier() {
    }

    public boolean onQuery(CefBrowser cefBrowser, CefFrame cefFrame, long queryId, String request, boolean persistent, CefQueryCallback cefQueryCallback) {
        this.log.info("Event Encoded Received: {}", (Object)request);
        JVaadinPanel panel = this.lookup.get(cefBrowser);
        if (panel == null) {
            this.log.warn("An action event was emitted from a CefBrowser, however, could not find panel in lookup table");
            return true;
        }
        if (!panel.isVisible()) {
            this.log.trace("Action event from an invisible panel");
            return true;
        }
        try {
            VaadinSwingEvent event = (VaadinSwingEvent)InvocationUtils.decode((String)request);
            if (SwingUtilities.isEventDispatchThread()) {
                SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
                new Thread(() -> {
                    this.log.trace("Firing event: {} on Panel {}", (Object)event.getType(), (Object)(panel.getName() == null ? panel.toString() : panel.getName()));
                    panel.fireEvent(event);
                    loop.exit();
                }).start();
                loop.enter();
            } else {
                this.log.debug("Before firing event: {} on Panel {}", (Object)event.getType(), (Object)(panel.getName() == null ? panel.toString() : panel.getName()));
                SwingUtilities.invokeLater(() -> {
                    panel.fireEvent(event);
                    this.log.trace("Firing event: {} on Panel {}", (Object)event.getType(), (Object)(panel.getName() == null ? panel.toString() : panel.getName()));
                });
            }
            return true;
        }
        catch (Exception e) {
            this.log.info("Event processing failed: " + e.getMessage());
            return false;
        }
    }

    void addPanel(CefBrowser browser, JCefJVaadinPanel panel) {
        this.lookup.put(browser, panel);
    }
}

