/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.client.jcef;

import com.vaadin.swingkit.client.JVaadinPanel;
import com.vaadin.swingkit.client.SwingVaadinClient;
import com.vaadin.swingkit.client.SwingVaadinException;
import com.vaadin.swingkit.client.VaadinPanelBuilder;
import com.vaadin.swingkit.client.jcef.JCefJVaadinPanel;
import com.vaadin.swingkit.client.jcef.SwingKitFocusHandler;
import com.vaadin.swingkit.client.jcef.VaadinJCefEventNotifier;
import com.vaadin.swingkit.client.jcef.VaadinJCefLoadHandler;
import com.vaadin.swingkit.client.jcef.VaadinJCefRequestHandler;
import com.vaadin.swingkit.client.jcef.VaadinQueryMessageHandler;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.io.IOException;
import me.friwi.jcefmaven.CefAppBuilder;
import me.friwi.jcefmaven.CefInitializationException;
import me.friwi.jcefmaven.IProgressHandler;
import me.friwi.jcefmaven.MavenCefAppHandlerAdapter;
import me.friwi.jcefmaven.UnsupportedPlatformException;
import me.friwi.jcefmaven.impl.progress.ConsoleProgressHandler;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRequestHandler;

public class JCefVaadinPanelBuilder
extends VaadinPanelBuilder {
    private static CefClient client;
    private static VaadinJCefEventNotifier actionMessageHandler;
    private static VaadinJCefLoadHandler loadHandler;

    private void init() throws UnsupportedPlatformException, CefInitializationException, IOException, InterruptedException {
        CefAppBuilder builder = new CefAppBuilder();
        builder.setInstallDir(new File(new File(System.getProperty("user.home")), ".jcef-bundle"));
        builder.setProgressHandler((IProgressHandler)new ConsoleProgressHandler(){});
        if (OS.isLinux()) {
            builder.addJcefArgs(new String[]{"--disable-gpu"});
        }
        builder.getCefSettings().windowless_rendering_enabled = OS.isLinux();
        builder.getCefSettings().user_agent = "JCefBrowser";
        builder.setAppHandler(new MavenCefAppHandlerAdapter(){

            public void stateHasChanged(CefApp.CefAppState state) {
                if (state == CefApp.CefAppState.TERMINATED) {
                    System.exit(0);
                }
            }
        });
        CefApp app = builder.build();
        client = app.createClient();
        CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig();
        config.jsQueryFunction = "vaadinQuery";
        config.jsCancelFunction = "vaadinQueryCancel";
        CefMessageRouter messageRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)config);
        messageRouter.addHandler((CefMessageRouterHandler)new VaadinQueryMessageHandler(), true);
        client.addMessageRouter(messageRouter);
        CefMessageRouter.CefMessageRouterConfig actionConfig = new CefMessageRouter.CefMessageRouterConfig();
        actionConfig.jsQueryFunction = "vaadinActionQuery";
        actionConfig.jsCancelFunction = "vaadinActionQueryCancel";
        CefMessageRouter actionMessageRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)actionConfig);
        actionMessageHandler = new VaadinJCefEventNotifier();
        actionMessageRouter.addHandler((CefMessageRouterHandler)actionMessageHandler, true);
        client.addMessageRouter(actionMessageRouter);
        loadHandler = new VaadinJCefLoadHandler();
        client.addLoadHandler((CefLoadHandler)loadHandler);
        client.addRequestHandler((CefRequestHandler)new VaadinJCefRequestHandler());
        if (SwingVaadinClient.getConfiguration().isSmartFocus()) {
            SwingKitFocusHandler focusHandler = new SwingKitFocusHandler();
            client.addKeyboardHandler((CefKeyboardHandler)focusHandler);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(focusHandler);
        }
    }

    protected void fillPanel(String viewUrl, JVaadinPanel panel) throws SwingVaadinException {
        if (client == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new SwingVaadinException(e);
            }
        }
        CefBrowser browser = client.createBrowser(viewUrl, OS.isLinux(), false);
        actionMessageHandler.addPanel(browser, (JCefJVaadinPanel)panel);
        loadHandler.addPanel(browser, (JCefJVaadinPanel)panel);
        ((JCefJVaadinPanel)panel).addCefBrowser(browser);
    }

    protected Class<? extends JVaadinPanel> getPanelClass() {
        return JCefJVaadinPanel.class;
    }
}

