/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.client.jcef;

import java.nio.ByteBuffer;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

class VaadinJCefResourceHandler
implements CefResourceHandler {
    private int startPos = 0;
    private String html = "<!DOCTYPE html>\r\n<html>\r\n<head>\r\n<meta charset=\"UTF-8\">\r\n<title>Swing Kit Error</title>\r\n<style>\r\n:root {\r\n  --button: #b3b3b3;\r\n  --button-color: #0a0a0a;\r\n  --shadow: #000;\r\n  --bg: #737373;\r\n  --header: #7a7a7a;\r\n  --color: #fafafa;\r\n  --lit-header: #e6e6e6;\r\n}\r\n\r\nbody {\r\n  min-height: 100vh;\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  justify-content: center;\r\n  background: var(--bg);\r\n  color: var(--color);\r\n  perspective: 1200px;\r\n}\r\na {\r\n  text-transform: uppercase;\r\n  text-decoration: none;\r\n  background: var(--button);\r\n  color: var(--button-color);\r\n  padding: 1rem 4rem;\r\n  border-radius: 4rem;\r\n  font-size: 0.875rem;\r\n  letter-spacing: 0.05rem;\r\n}\r\np {\r\n  font-weight: 100;\r\n}\r\nh1 {\r\n  margin: 0;\r\n  margin-bottom: 1rem;\r\n  letter-spacing: 1rem;\r\n}\r\n.info {\r\n  text-align: center;\r\n  line-height: 1.5;\r\n  max-width: clamp(16rem, 90vmin, 25rem);\r\n}\r\n.info > p {\r\n  margin-bottom: 3rem;\r\n}\r\n\r\n</style>\r\n</head>\r\n<body>\r\n\t<h1>Unreachable page</h1>\r\n\t<div class=\"info\">\r\n\t\t<h2>Swing Kit can't reach that page</h2>\r\n\t\t<p>Please check that the server is reachable and reload.</p>\r\n\t\t<a href=\"%%URLTORELOAD%%\">Reload</a>\r\n\t</div>\r\n</body>\r\n</html>";

    VaadinJCefResourceHandler(String previousUrl) {
        this.html = this.html.replace("%%URLTORELOAD%%", previousUrl);
    }

    public boolean processRequest(CefRequest request, CefCallback callback) {
        this.startPos = 0;
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(CefResponse response, IntRef response_length, StringRef redirectUrl) {
        response_length.set(this.html.length());
        response.setMimeType("text/html");
        response.setStatus(200);
    }

    public boolean readResponse(byte[] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
        int length = this.html.length();
        if (this.startPos >= length) {
            return false;
        }
        int endPos = this.startPos + bytes_to_read;
        String dataToSend = endPos > length ? this.html.substring(this.startPos) : this.html.substring(this.startPos, endPos);
        ByteBuffer result = ByteBuffer.wrap(data_out);
        result.put(dataToSend.getBytes());
        bytes_read.set(dataToSend.length());
        this.startPos = endPos;
        return true;
    }

    public void cancel() {
        this.startPos = 0;
    }
}

