/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.client;

import com.vaadin.swingkit.client.SwingVaadinClient;
import com.vaadin.swingkit.client.SwingVaadinException;
import com.vaadin.swingkit.core.InvocationResponse;
import com.vaadin.swingkit.core.InvocationUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinRequestsManager {
    private final Logger log = LoggerFactory.getLogger(VaadinRequestsManager.class);
    private final ConcurrentHashMap<String, Semaphore> status = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> responses = new ConcurrentHashMap();

    public void registerRequest(String id) {
        this.status.put(id, new Semaphore(0));
    }

    public void registerResponse(String encodedResponse) {
        this.log.info("Response encoded: {}", (Object)encodedResponse);
        InvocationResponse ir = null;
        try {
            ir = (InvocationResponse)InvocationUtils.decode((String)encodedResponse);
            this.log.info("Response decoded: {}", (Object)ir);
            if (!ir.getClassType().equals("void")) {
                Class.forName(ir.getClassType());
                Object response = ir.getData();
                this.responses.put(ir.getId(), response);
            }
        }
        catch (Exception ex) {
            this.responses.put(ir.getId(), ex);
        }
        if (this.status.containsKey(ir.getId())) {
            this.status.get(ir.getId()).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T waitForResponse(String id, long timeout) throws InterruptedException, SwingVaadinException {
        Object response;
        boolean acquired;
        try {
            this.log.info("Waiting on: {}", (Object)this.status.get(id));
            acquired = this.status.get(id).tryAcquire(timeout, TimeUnit.SECONDS);
        }
        finally {
            response = this.responses.remove(id);
        }
        if (acquired) {
            if (response == null) {
                this.log.warn("Result is missing - ID: {}", (Object)id);
            } else if (response instanceof Exception) {
                SwingVaadinException exception = new SwingVaadinException("Exception occurred in remote vaadin invocation", (Exception)response);
                this.log.error(exception.getMessage());
                throw exception;
            }
        } else {
            SwingVaadinException exception = new SwingVaadinException("Response not ready in specified timeout (" + timeout + "s) - ID " + id);
            this.log.error(exception.getMessage());
            throw exception;
        }
        Object result = response;
        return (T)result;
    }

    public <T> T waitForResponse(String id) throws Exception {
        return this.waitForResponse(id, SwingVaadinClient.getConfiguration().getTimeout());
    }
}

