/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.client;

import com.vaadin.swingkit.client.SwingKitConfiguration;
import com.vaadin.swingkit.client.VaadinPanelBuilder;
import com.vaadin.swingkit.client.VaadinRequestsManager;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.locks.ReentrantLock;

public final class SwingVaadinClient {
    private static final String VAADIN_PANEL_BUILDER_JCEF = "com.vaadin.swingkit.client.jcef.JCefVaadinPanelBuilder";
    private static final String VAADIN_PANEL_BUILDER_JXBROWSER = "com.vaadin.swingkit.client.jxbrowser.JxBrowserVaadinPanelBuilder";
    private static VaadinPanelBuilder builder;
    private static VaadinRequestsManager requestsManager;
    private static SwingKitConfiguration configuration;
    private static final ReentrantLock lock;

    private SwingVaadinClient() {
    }

    private static void init() {
        if (builder == null) {
            lock.lock();
            try {
                if (builder == null) {
                    builder = SwingVaadinClient.fetchImpl();
                    requestsManager = new VaadinRequestsManager();
                    configuration = new SwingKitConfiguration();
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static VaadinPanelBuilder getBuilder() {
        SwingVaadinClient.init();
        return builder;
    }

    public static SwingKitConfiguration getConfiguration() {
        SwingVaadinClient.init();
        return configuration;
    }

    public static VaadinRequestsManager getRequestsManager() {
        SwingVaadinClient.init();
        return requestsManager;
    }

    private static VaadinPanelBuilder fetchImpl() {
        Class<?> builderClass;
        try {
            builderClass = Class.forName(VAADIN_PANEL_BUILDER_JCEF);
        }
        catch (ClassNotFoundException e) {
            try {
                builderClass = Class.forName(VAADIN_PANEL_BUILDER_JXBROWSER);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Can't find VaadinPanelBuilder implementations in the classpath, import either swing-vaadin-client-jcef or swing-vaadin-client-jxbrowser");
            }
        }
        try {
            return (VaadinPanelBuilder)builderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

