/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.client;

import com.vaadin.swingkit.client.VaadinEventListener;
import com.vaadin.swingkit.core.VaadinSwingEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@FunctionalInterface
public interface VaadinEventNotifier {
    default public void addEventListener(String eventType, VaadinEventListener eventListener) {
        boolean contained = this.getListeners().computeIfAbsent(eventType, k -> new LinkedList()).contains(eventListener);
        if (!contained) {
            this.getListeners().get(eventType).add(eventListener);
        }
    }

    default public void removeEventListener(String eventType, VaadinEventListener eventListener) {
        this.getListeners().computeIfAbsent(eventType, k -> new LinkedList()).remove(eventListener);
    }

    default public void fireEvent(VaadinSwingEvent event) {
        this.getListeners().computeIfAbsent(event.getType(), k -> new LinkedList()).forEach(listener -> listener.handleEvent(event));
    }

    default public void clearListeners(String eventType) {
        this.getListeners().computeIfAbsent(eventType, k -> new LinkedList()).clear();
    }

    default public void clearListeners() {
        this.getListeners().clear();
    }

    public Map<String, List<VaadinEventListener>> getListeners();
}

