/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.swingkit.client;

import com.vaadin.swingkit.client.VaadinEventListener;
import com.vaadin.swingkit.client.VaadinEventNotifier;
import com.vaadin.swingkit.client.VaadinPanelProxyBuilder;
import com.vaadin.swingkit.core.SwingKitException;
import com.vaadin.swingkit.core.SwingVaadinCallable;
import java.awt.BorderLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class JVaadinPanel
extends JPanel
implements VaadinEventNotifier {
    private final Map<String, List<VaadinEventListener>> listeners = new HashMap<String, List<VaadinEventListener>>();
    private final VaadinEventListener detachEventListener = event -> {
        this.ready = false;
    };
    private final VaadinEventListener attachEventListener = event -> {
        this.ready = true;
    };
    private final VaadinEventListener defaultExceptionHandler = event -> {
        JOptionPane.showMessageDialog(this, event.getParams().get("content"));
        if (SwingKitException.NETWORK_EXCEPTION.equals(event.getParams().get("type"))) {
            this.navigateTo("notreachableerror.html");
        }
    };
    protected boolean ready = false;

    protected JVaadinPanel() {
        super(new BorderLayout());
        this.addEventListener("attach-bridge", this.attachEventListener);
        this.addEventListener("detach-bridge", this.detachEventListener);
        this.addDefaultExceptionHandler();
    }

    protected abstract void executeJs(String var1);

    public <T extends SwingVaadinCallable> T as(Class<T> swingVaadinInterface) {
        try {
            return VaadinPanelProxyBuilder.getInstance().newSwingVaadinInterface(this, swingVaadinInterface);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public abstract void reload();

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setBrowserName(name);
    }

    protected abstract void setBrowserName(String var1);

    protected abstract void navigateTo(String var1);

    public final void addDefaultExceptionHandler() {
        this.addEventListener("exception", this.defaultExceptionHandler);
    }

    public final void removeDefaultExceptionHandler() {
        this.removeEventListener("exception", this.defaultExceptionHandler);
    }

    @Override
    public Map<String, List<VaadinEventListener>> getListeners() {
        return this.listeners;
    }

    @Override
    public final void clearListeners(String eventType) {
        VaadinEventNotifier.super.clearListeners(eventType);
        if (eventType.equals("attach-bridge")) {
            this.addEventListener("attach-bridge", this.attachEventListener);
        } else if (eventType.equals("detach-bridge")) {
            this.addEventListener("detach-bridge", this.detachEventListener);
        }
    }

    @Override
    public final void clearListeners() {
        VaadinEventNotifier.super.clearListeners();
        this.addEventListener("attach-bridge", this.attachEventListener);
        this.addEventListener("detach-bridge", this.detachEventListener);
    }
}

