/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security.stateless;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.vaadin.flow.spring.security.VaadinDefaultRequestCache;
import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import com.vaadin.flow.spring.security.stateless.JwtSecurityContextRepository;
import com.vaadin.flow.spring.security.stateless.SerializedJwtSplitCookieRepository;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.crypto.SecretKey;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.context.DelegatingSecurityContextRepository;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.savedrequest.CookieRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.OnCommittedResponseWrapper;
import org.springframework.web.filter.OncePerRequestFilter;

public final class VaadinStatelessSecurityConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<VaadinStatelessSecurityConfigurer<H>, H> {
    private long expiresIn = 1800L;
    private String issuer;
    private SecretKeyConfigurer secretKeyConfigurer;

    @Deprecated(since="24.8", forRemoval=true)
    public static void apply(HttpSecurity http, Customizer<VaadinStatelessSecurityConfigurer<HttpSecurity>> customizer) throws Exception {
        VaadinStatelessSecurityConfigurer vaadinStatelessSecurityConfigurer = new VaadinStatelessSecurityConfigurer();
        http.with(vaadinStatelessSecurityConfigurer, customizer);
    }

    public void init(H http) throws Exception {
        CsrfConfigurer csrf;
        JwtSecurityContextRepository jwtSecurityContextRepository = new JwtSecurityContextRepository(new SerializedJwtSplitCookieRepository());
        http.setSharedObject(JwtSecurityContextRepository.class, (Object)jwtSecurityContextRepository);
        if (http instanceof HttpSecurity) {
            HttpSecurity httpSecurity = (HttpSecurity)http;
            httpSecurity.securityContext(cfg -> {
                DelegatingSecurityContextRepository repository = new DelegatingSecurityContextRepository(new SecurityContextRepository[]{jwtSecurityContextRepository, new RequestAttributeSecurityContextRepository()});
                cfg.securityContextRepository((SecurityContextRepository)repository);
            });
        }
        if ((csrf = (CsrfConfigurer)http.getConfigurer(CsrfConfigurer.class)) != null) {
            CookieCsrfTokenRepository csrfTokenRepository = CookieCsrfTokenRepository.withHttpOnlyFalse();
            XorCsrfTokenRequestAttributeHandler delegate = new XorCsrfTokenRequestAttributeHandler();
            CsrfTokenRequestHandler requestHandler = (arg_0, arg_1, arg_2) -> ((XorCsrfTokenRequestAttributeHandler)delegate).handle(arg_0, arg_1, arg_2);
            csrf.csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository);
            csrf.csrfTokenRequestHandler(requestHandler);
            csrf.sessionAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
            ((VaadinSavedRequestAwareAuthenticationSuccessHandler)((Object)http.getSharedObject(VaadinSavedRequestAwareAuthenticationSuccessHandler.class))).setCsrfTokenRepository((CsrfTokenRepository)csrfTokenRepository);
        }
    }

    public void configure(H http) {
        RequestCache requestCache;
        JwtSecurityContextRepository jwtSecurityContextRepository = (JwtSecurityContextRepository)http.getSharedObject(JwtSecurityContextRepository.class);
        if (jwtSecurityContextRepository != null) {
            jwtSecurityContextRepository.setJwsAlgorithm(this.secretKeyConfigurer.getAlgorithm());
            jwtSecurityContextRepository.setJwkSource(this.secretKeyConfigurer.getJWKSource());
            jwtSecurityContextRepository.setIssuer(this.issuer);
            jwtSecurityContextRepository.setExpiresIn(this.expiresIn);
            AuthenticationTrustResolver trustResolver = (AuthenticationTrustResolver)http.getSharedObject(AuthenticationTrustResolver.class);
            if (trustResolver == null) {
                trustResolver = new AuthenticationTrustResolverImpl();
            }
            jwtSecurityContextRepository.setTrustResolver(trustResolver);
            http.addFilterBefore((Filter)new UpdateJwtCookiesFilter(jwtSecurityContextRepository), HeaderWriterFilter.class);
        }
        if ((requestCache = (RequestCache)http.getSharedObject(RequestCache.class)) instanceof VaadinDefaultRequestCache) {
            ((VaadinDefaultRequestCache)requestCache).setDelegateRequestCache((RequestCache)new CookieRequestCache());
        }
    }

    public VaadinStatelessSecurityConfigurer<H> expiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    public VaadinStatelessSecurityConfigurer<H> issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public SecretKeyConfigurer withSecretKey() {
        if (this.secretKeyConfigurer == null) {
            this.secretKeyConfigurer = new SecretKeyConfigurer();
        }
        return this.secretKeyConfigurer;
    }

    public VaadinStatelessSecurityConfigurer<H> withSecretKey(Customizer<SecretKeyConfigurer> customizer) {
        if (this.secretKeyConfigurer == null) {
            this.secretKeyConfigurer = new SecretKeyConfigurer();
        }
        customizer.customize((Object)this.secretKeyConfigurer);
        return this;
    }

    public class SecretKeyConfigurer {
        private SecretKey secretKey;
        private JwsAlgorithm jwsAlgorithm;

        private SecretKeyConfigurer() {
        }

        public SecretKeyConfigurer secretKey(SecretKey secretKey) {
            this.secretKey = secretKey;
            if (this.jwsAlgorithm == null) {
                this.jwsAlgorithm = MacAlgorithm.from((String)secretKey.getAlgorithm());
            }
            return this;
        }

        public SecretKeyConfigurer algorithm(MacAlgorithm algorithm) {
            this.jwsAlgorithm = algorithm;
            return this;
        }

        public VaadinStatelessSecurityConfigurer<H> and() {
            return VaadinStatelessSecurityConfigurer.this;
        }

        JWKSource<SecurityContext> getJWKSource() {
            OctetSequenceKey key = new OctetSequenceKey.Builder(this.secretKey).algorithm((Algorithm)this.getAlgorithm()).build();
            JWKSet jwkSet = new JWKSet((JWK)key);
            return (jwkSelector, context) -> jwkSelector.select(jwkSet);
        }

        JWSAlgorithm getAlgorithm() {
            return JWSAlgorithm.parse((String)this.jwsAlgorithm.getName());
        }
    }

    private static final class UpdateJwtCookiesFilter
    extends OncePerRequestFilter {
        private final JwtSecurityContextRepository jwtSecurityContextRepository;

        private UpdateJwtCookiesFilter(JwtSecurityContextRepository jwtSecurityContextRepository) {
            this.jwtSecurityContextRepository = jwtSecurityContextRepository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            UpdateJWTCookieOnCommitResponseWrapper responseWrapper = new UpdateJWTCookieOnCommitResponseWrapper(request, response, this.jwtSecurityContextRepository);
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            }
            finally {
                responseWrapper.writeCookies();
            }
        }
    }

    private static final class UpdateJWTCookieOnCommitResponseWrapper
    extends OnCommittedResponseWrapper {
        private final JwtSecurityContextRepository jwtSecurityContextRepository;
        private final HttpServletRequest request;

        UpdateJWTCookieOnCommitResponseWrapper(HttpServletRequest request, HttpServletResponse response, JwtSecurityContextRepository jwtSecurityContextRepository) {
            super(response);
            this.request = request;
            this.jwtSecurityContextRepository = jwtSecurityContextRepository;
        }

        protected void onResponseCommitted() {
            this.writeCookies();
            this.disableOnResponseCommitted();
        }

        private void writeCookies() {
            if (this.isDisableOnResponseCommitted()) {
                return;
            }
            org.springframework.security.core.context.SecurityContext context = SecurityContextHolder.getContextHolderStrategy().getContext();
            if (context != null && !SerializedJwtSplitCookieRepository.containsCookie((HttpServletResponse)this)) {
                this.jwtSecurityContextRepository.saveContext(context, this.request, (HttpServletResponse)this);
            }
        }
    }
}

