/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.spring.annotation.EnableVaadin;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public class VaadinScanPackagesRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        String[] packages = this.getPackages(annotationMetadata, EnableVaadin.class, "value");
        if (packages.length > 0) {
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(VaadinScanPackages.class);
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)packages);
            beanDefinition.setRole(2);
            registry.registerBeanDefinition(VaadinScanPackages.class.getName(), (BeanDefinition)beanDefinition);
        }
    }

    private <T> T getPackages(Class<T> clazz, AnnotationMetadata annotationMetadata, Class<? extends Annotation> annotation, String getterName) {
        String annotationName = annotation.getName();
        if (annotationMetadata.hasAnnotation(annotationName)) {
            Map annotationAttributes = annotationMetadata.getAnnotationAttributes(annotationName);
            return annotationAttributes != null ? (T)clazz.cast(annotationAttributes.get(getterName)) : null;
        }
        return null;
    }

    private String[] getPackages(AnnotationMetadata annotationMetadata, Class<? extends Annotation> annotation, String getterName) {
        String[] packages = this.getPackages(String[].class, annotationMetadata, annotation, getterName);
        if (packages == null) {
            return new String[0];
        }
        return packages;
    }

    static class VaadinScanPackages {
        private final List<String> scanPackages;

        private VaadinScanPackages(String[] scanPackages) {
            assert (scanPackages != null);
            this.scanPackages = Collections.unmodifiableList(Arrays.asList(scanPackages));
        }

        List<String> getScanPackages() {
            return this.scanPackages;
        }
    }
}

