/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.RoutePathAccessChecker;
import com.vaadin.flow.spring.security.AuthenticationContext;
import com.vaadin.flow.spring.security.RequestUtil;
import com.vaadin.flow.spring.security.UidlRedirectStrategy;
import com.vaadin.flow.spring.security.VaadinDefaultRequestCache;
import com.vaadin.flow.spring.security.VaadinRolePrefixHolder;
import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import com.vaadin.flow.spring.security.VaadinSimpleUrlLogoutSuccessHandler;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestCacheConfigurer;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.access.RequestMatcherDelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.csrf.CsrfException;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatchers;
import org.springframework.web.context.WebApplicationContext;

public final class VaadinSecurityConfigurer
extends AbstractHttpConfigurer<VaadinSecurityConfigurer, HttpSecurity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaadinSecurityConfigurer.class);
    private final List<LogoutHandler> logoutHandlers = new ArrayList<LogoutHandler>();
    private Class<? extends Component> loginView;
    private String formLoginPage;
    private String oauth2LoginPage;
    private String logoutSuccessUrl;
    private String postLogoutRedirectUri;
    private boolean enableCsrfConfiguration = true;
    private boolean enableLogoutConfiguration = true;
    private boolean enableRequestCacheConfiguration = true;
    private boolean enableExceptionHandlingConfiguration = true;
    private boolean enableAuthorizedRequestsConfiguration = true;
    private Consumer<AuthorizeHttpRequestsConfigurer.AuthorizedUrl> anyRequestAuthorizeRule = AuthorizeHttpRequestsConfigurer.AuthorizedUrl::denyAll;
    private boolean enableNavigationAccessControl = true;
    private boolean alreadyInitializedOnce = false;

    public static VaadinSecurityConfigurer vaadin() {
        return new VaadinSecurityConfigurer();
    }

    private VaadinSecurityConfigurer() {
    }

    public VaadinSecurityConfigurer loginView(Class<? extends Component> loginView) {
        return this.loginView(loginView, this.getDefaultLogoutSuccessUrl());
    }

    public VaadinSecurityConfigurer loginView(Class<? extends Component> loginView, String logoutSuccessUrl) {
        this.loginView = loginView;
        String loginViewPath = this.getLoginViewPath(loginView);
        this.formLoginPage = this.getRequestUtil().applyUrlMapping(loginViewPath);
        this.logoutSuccessUrl = logoutSuccessUrl;
        return this;
    }

    public VaadinSecurityConfigurer loginView(String loginView) {
        return this.loginView(loginView, this.getDefaultLogoutSuccessUrl());
    }

    public VaadinSecurityConfigurer loginView(String loginView, String logoutSuccessUrl) {
        this.formLoginPage = this.getRequestUtil().applyUrlMapping(loginView);
        this.logoutSuccessUrl = logoutSuccessUrl;
        return this;
    }

    public VaadinSecurityConfigurer oauth2LoginPage(String oauth2LoginPage) {
        return this.oauth2LoginPage(oauth2LoginPage, "{baseUrl}");
    }

    public VaadinSecurityConfigurer oauth2LoginPage(String oauth2LoginPage, String postLogoutRedirectUri) {
        this.oauth2LoginPage = oauth2LoginPage;
        this.postLogoutRedirectUri = postLogoutRedirectUri;
        return this;
    }

    public VaadinSecurityConfigurer logoutSuccessHandler(LogoutSuccessHandler logoutSuccessHandler) {
        this.setSharedObject(LogoutSuccessHandler.class, logoutSuccessHandler);
        return this;
    }

    public VaadinSecurityConfigurer addLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandlers.add(logoutHandler);
        return this;
    }

    public VaadinSecurityConfigurer enableCsrfConfiguration(boolean enableCsrfConfiguration) {
        this.enableCsrfConfiguration = enableCsrfConfiguration;
        return this;
    }

    public VaadinSecurityConfigurer enableLogoutConfiguration(boolean enableLogoutConfiguration) {
        this.enableLogoutConfiguration = enableLogoutConfiguration;
        return this;
    }

    public VaadinSecurityConfigurer enableRequestCacheConfiguration(boolean enableRequestCacheConfiguration) {
        this.enableRequestCacheConfiguration = enableRequestCacheConfiguration;
        return this;
    }

    public VaadinSecurityConfigurer enableExceptionHandlingConfiguration(boolean enableExceptionHandlingConfiguration) {
        this.enableExceptionHandlingConfiguration = enableExceptionHandlingConfiguration;
        return this;
    }

    public VaadinSecurityConfigurer enableAuthorizedRequestsConfiguration(boolean enableAuthorizedRequestsConfiguration) {
        this.enableAuthorizedRequestsConfiguration = enableAuthorizedRequestsConfiguration;
        return this;
    }

    public VaadinSecurityConfigurer anyRequest(Consumer<AuthorizeHttpRequestsConfigurer.AuthorizedUrl> anyRequestAuthorizeRule) {
        this.anyRequestAuthorizeRule = anyRequestAuthorizeRule;
        return this;
    }

    public VaadinSecurityConfigurer enableNavigationAccessControl(boolean enableNavigationAccessControl) {
        this.enableNavigationAccessControl = enableNavigationAccessControl;
        return this;
    }

    public RequestMatcher defaultPermitMatcher() {
        String urlMapping = this.getRequestUtil().getUrlMapping();
        RequestMatcher[] requestMatcherArray = new RequestMatcher[5];
        requestMatcherArray[0] = this.getRequestUtil()::isFrameworkInternalRequest;
        requestMatcherArray[1] = this.getRequestUtil()::isAnonymousRoute;
        requestMatcherArray[2] = this.getRequestUtil()::isCustomWebIcon;
        requestMatcherArray[3] = VaadinSecurityConfigurer.getDefaultHttpSecurityPermitMatcher(urlMapping);
        requestMatcherArray[4] = VaadinSecurityConfigurer.getDefaultWebSecurityIgnoreMatcher(urlMapping);
        RequestMatcher baseMatcher = RequestMatchers.anyOf((RequestMatcher[])requestMatcherArray);
        if (EndpointRequestUtil.isHillaAvailable()) {
            RequestMatcher[] requestMatcherArray2 = new RequestMatcher[3];
            requestMatcherArray2[0] = baseMatcher;
            requestMatcherArray2[1] = this.getRequestUtil()::isAllowedHillaView;
            requestMatcherArray2[2] = this.getRequestUtil()::isAnonymousEndpoint;
            return this.toRequestPrincipalAwareMatcher(RequestMatchers.anyOf((RequestMatcher[])requestMatcherArray2));
        }
        return this.toRequestPrincipalAwareMatcher(baseMatcher);
    }

    private RequestMatcher toRequestPrincipalAwareMatcher(RequestMatcher matcher) {
        if (this.enableNavigationAccessControl && this.getNavigationAccessControl().hasAccessChecker(RoutePathAccessChecker.class)) {
            return RequestUtil.principalAwareRequestMatcher(matcher);
        }
        return matcher;
    }

    public void init(HttpSecurity http) throws Exception {
        if (this.formLoginPage != null) {
            http.formLogin(configurer -> {
                configurer.loginPage(this.formLoginPage).permitAll();
                configurer.successHandler((AuthenticationSuccessHandler)this.getAuthenticationSuccessHandler());
            });
        } else if (this.oauth2LoginPage != null) {
            http.oauth2Login(configurer -> {
                configurer.loginPage(this.oauth2LoginPage).permitAll();
                configurer.successHandler((AuthenticationSuccessHandler)this.getAuthenticationSuccessHandler());
            });
        }
        if (this.enableCsrfConfiguration) {
            http.csrf(this::customizeCsrf);
        }
        if (this.enableLogoutConfiguration) {
            http.logout(this::customizeLogout);
        }
        if (this.enableRequestCacheConfiguration) {
            http.requestCache(this::customizeRequestCache);
        }
        if (this.enableExceptionHandlingConfiguration) {
            http.exceptionHandling(this::customizeExceptionHandling);
        }
        if (this.enableAuthorizedRequestsConfiguration && !this.alreadyInitializedOnce) {
            http.authorizeHttpRequests(this::customizeAuthorizeHttpRequests);
        }
        this.alreadyInitializedOnce = true;
    }

    public void configure(HttpSecurity http) throws Exception {
        VaadinRolePrefixHolder rolePrefixHolder = this.getVaadinRolePrefixHolder();
        if (rolePrefixHolder != null) {
            this.getAuthenticationContext().setRolePrefixHolder(rolePrefixHolder);
            this.getSharedObject(SecurityContextHolderAwareRequestFilter.class).ifPresent(rolePrefixHolder::resetRolePrefix);
        }
        this.getNavigationAccessControl().setEnabled(this.enableNavigationAccessControl);
        if (this.enableNavigationAccessControl) {
            if (this.loginView != null) {
                this.getNavigationAccessControl().setLoginView(this.loginView);
            } else if (this.formLoginPage != null) {
                this.getNavigationAccessControl().setLoginView(this.formLoginPage);
            } else if (this.oauth2LoginPage != null) {
                this.getNavigationAccessControl().setLoginView(this.oauth2LoginPage);
            }
        }
        if (this.enableAuthorizedRequestsConfiguration && this.anyRequestAuthorizeRule != null) {
            http.authorizeHttpRequests(registry -> this.anyRequestAuthorizeRule.accept((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()));
        }
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher() {
        return VaadinSecurityConfigurer.getDefaultHttpSecurityPermitMatcher("/*");
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher(String urlMapping) {
        Objects.requireNonNull(urlMapping, "Vaadin servlet url mapping is required");
        PathPatternRequestMatcher.Builder builder = PathPatternRequestMatcher.withDefaults();
        String[] paths = HandlerHelper.getPublicResourcesRequiringSecurityContext();
        assert (paths.length > 0);
        return new OrRequestMatcher((RequestMatcher[])Stream.of(paths).map(path -> RequestUtil.applyUrlMapping(urlMapping, path)).map(arg_0 -> ((PathPatternRequestMatcher.Builder)builder).matcher(arg_0)).toArray(RequestMatcher[]::new));
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher() {
        return VaadinSecurityConfigurer.getDefaultWebSecurityIgnoreMatcher("/*");
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher(String urlMapping) {
        Objects.requireNonNull(urlMapping, "Vaadin servlet url mapping is required");
        ArrayList matchers = new ArrayList();
        PathPatternRequestMatcher.Builder builder = PathPatternRequestMatcher.withDefaults();
        String[] publicResources = HandlerHelper.getPublicResources();
        assert (publicResources.length > 0);
        Stream.of(publicResources).map(path -> RequestUtil.applyUrlMapping(urlMapping, path)).map(arg_0 -> ((PathPatternRequestMatcher.Builder)builder).matcher(arg_0)).forEach(matchers::add);
        String[] publicResourcesRoot = HandlerHelper.getPublicResourcesRoot();
        assert (publicResourcesRoot.length > 0);
        Stream.of(publicResourcesRoot).map(arg_0 -> ((PathPatternRequestMatcher.Builder)builder).matcher(arg_0)).forEach(matchers::add);
        return new OrRequestMatcher(matchers);
    }

    private String getLoginViewPath(Class<? extends Component> loginView) {
        Optional route = AnnotationReader.getAnnotationFor(loginView, Route.class);
        if (route.isEmpty()) {
            throw new IllegalArgumentException("Unable find a @Route annotation on the login view " + loginView.getName());
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext instanceof WebApplicationContext) {
            WebApplicationContext wac = (WebApplicationContext)applicationContext;
            VaadinServletContext vaadinCtx = new VaadinServletContext(wac.getServletContext());
            Object loginPath = RouteUtil.getRoutePath((VaadinContext)vaadinCtx, loginView);
            if (!((String)loginPath).startsWith("/")) {
                loginPath = "/" + (String)loginPath;
            }
            return loginPath;
        }
        throw new IllegalStateException("VaadinSecurityConfigurer cannot be used without WebApplicationContext.");
    }

    private String getServletContextPath() {
        return this.getSharedObjectOrBean(ServletContext.class).getContextPath();
    }

    private String getDefaultLogoutSuccessUrl() {
        Object servletContextPath = this.getServletContextPath();
        if (!((String)servletContextPath).startsWith("/")) {
            servletContextPath = "/" + (String)servletContextPath;
        }
        return servletContextPath;
    }

    private RequestUtil getRequestUtil() {
        return this.getSharedObjectOrBean(RequestUtil.class);
    }

    private AuthenticationContext getAuthenticationContext() {
        return this.getSharedObjectOrBean(AuthenticationContext.class);
    }

    private NavigationAccessControl getNavigationAccessControl() {
        return this.getSharedObjectOrBean(NavigationAccessControl.class);
    }

    private VaadinRolePrefixHolder getVaadinRolePrefixHolder() {
        return this.getSharedObjectOrBean(VaadinRolePrefixHolder.class);
    }

    private VaadinDefaultRequestCache getVaadinDefaultRequestCache() {
        return this.getSharedObjectOrBean(VaadinDefaultRequestCache.class);
    }

    private VaadinSavedRequestAwareAuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        return this.getSharedObject(VaadinSavedRequestAwareAuthenticationSuccessHandler.class).orElseGet(this::createAuthenticationSuccessHandler);
    }

    private VaadinSavedRequestAwareAuthenticationSuccessHandler createAuthenticationSuccessHandler() {
        VaadinSavedRequestAwareAuthenticationSuccessHandler handler = new VaadinSavedRequestAwareAuthenticationSuccessHandler();
        handler.setDefaultTargetUrl(this.getRequestUtil().applyUrlMapping(""));
        this.getSharedObject(RequestCache.class).ifPresent(handler::setRequestCache);
        ((HttpSecurity)this.getBuilder()).setSharedObject(VaadinSavedRequestAwareAuthenticationSuccessHandler.class, (Object)handler);
        return handler;
    }

    private void customizeCsrf(CsrfConfigurer<HttpSecurity> configurer) {
        if (!this.alreadyInitializedOnce) {
            RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
            requestMatcherArray[0] = this.getRequestUtil()::isFrameworkInternalRequest;
            configurer.ignoringRequestMatchers(requestMatcherArray);
        }
        if (this.formLoginPage != null) {
            configurer.ignoringRequestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher(this.formLoginPage)});
        }
    }

    private void customizeLogout(final LogoutConfigurer<HttpSecurity> configurer) {
        this.getSharedObject(LogoutSuccessHandler.class).or(() -> {
            if (this.logoutSuccessUrl != null) {
                return this.createSimpleUrlLogoutSuccessHandler(this.logoutSuccessUrl);
            }
            if (this.postLogoutRedirectUri != null) {
                return this.createOidcLogoutSuccessHandler(this.postLogoutRedirectUri);
            }
            return Optional.empty();
        }).ifPresent(arg_0 -> configurer.logoutSuccessHandler(arg_0));
        List existingHandlers = configurer.getLogoutHandlers();
        this.logoutHandlers.stream().filter(handler -> !existingHandlers.contains(handler)).forEach(arg_0 -> configurer.addLogoutHandler(arg_0));
        if (!this.alreadyInitializedOnce) {
            ObjectPostProcessor<LogoutFilter> postProcessor = new ObjectPostProcessor<LogoutFilter>(){

                public <O extends LogoutFilter> O postProcess(O filter) {
                    VaadinSecurityConfigurer.this.getAuthenticationContext().setLogoutHandlers(configurer.getLogoutSuccessHandler(), configurer.getLogoutHandlers());
                    return filter;
                }
            };
            configurer.withObjectPostProcessor((ObjectPostProcessor)postProcessor);
        }
    }

    private Optional<LogoutSuccessHandler> createSimpleUrlLogoutSuccessHandler(String logoutSuccessUrl) {
        VaadinSimpleUrlLogoutSuccessHandler handler = new VaadinSimpleUrlLogoutSuccessHandler();
        handler.setRedirectStrategy((RedirectStrategy)new UidlRedirectStrategy());
        handler.setDefaultTargetUrl(logoutSuccessUrl);
        return Optional.of(handler);
    }

    private Optional<LogoutSuccessHandler> createOidcLogoutSuccessHandler(String postLogoutRedirectUri) {
        ClientRegistrationRepository crr = this.getSharedObjectOrBean(ClientRegistrationRepository.class);
        if (crr != null) {
            OidcClientInitiatedLogoutSuccessHandler handler = new OidcClientInitiatedLogoutSuccessHandler(crr);
            handler.setRedirectStrategy((RedirectStrategy)new UidlRedirectStrategy());
            handler.setPostLogoutRedirectUri(postLogoutRedirectUri);
            return Optional.of(handler);
        }
        LOGGER.warn("Cannot create OidcClientInitiatedLogoutSuccessHandler because ClientRegistrationRepository bean is not available.");
        return Optional.empty();
    }

    private void customizeRequestCache(RequestCacheConfigurer<HttpSecurity> configurer) {
        VaadinDefaultRequestCache vaadinDefaultRequestCache = this.getVaadinDefaultRequestCache();
        if (vaadinDefaultRequestCache == null) {
            throw new IllegalStateException("No VaadinDefaultRequestCache bean or shared object found. Please make sure that either a bean or shared object of type VaadinDefaultRequestCache is available.");
        }
        this.getSharedObject(RequestCache.class).filter(cache -> !(cache instanceof VaadinDefaultRequestCache)).ifPresent(vaadinDefaultRequestCache::setDelegateRequestCache);
        this.getSharedObject(VaadinSavedRequestAwareAuthenticationSuccessHandler.class).ifPresent(vaadinSavedRequestAwareAuthenticationSuccessHandler -> vaadinSavedRequestAwareAuthenticationSuccessHandler.setRequestCache(vaadinDefaultRequestCache));
        configurer.requestCache((RequestCache)vaadinDefaultRequestCache);
    }

    private void customizeExceptionHandling(ExceptionHandlingConfigurer<HttpSecurity> configurer) {
        if (EndpointRequestUtil.isHillaAvailable()) {
            configurer.accessDeniedHandler(this.createAccessDeniedHandler()).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), this.getRequestUtil()::isEndpointRequest);
        }
        if (this.formLoginPage != null) {
            configurer.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(this.formLoginPage), AnyRequestMatcher.INSTANCE);
        }
    }

    private AccessDeniedHandler createAccessDeniedHandler() {
        LinkedHashMap<Class<CsrfException>, AccessDeniedHandler> exceptionHandlers = new LinkedHashMap<Class<CsrfException>, AccessDeniedHandler>();
        exceptionHandlers.put(CsrfException.class, (req, res, exc) -> res.setStatus(HttpStatus.UNAUTHORIZED.value()));
        LinkedHashMap<RequestMatcher, DelegatingAccessDeniedHandler> requestHandlers = new LinkedHashMap<RequestMatcher, DelegatingAccessDeniedHandler>();
        requestHandlers.put(this.getRequestUtil()::isEndpointRequest, new DelegatingAccessDeniedHandler(exceptionHandlers, (AccessDeniedHandler)new AccessDeniedHandlerImpl()));
        return new RequestMatcherDelegatingAccessDeniedHandler(requestHandlers, (AccessDeniedHandler)new AccessDeniedHandlerImpl());
    }

    private void customizeAuthorizeHttpRequests(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry registry) {
        RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
        requestMatcherArray[0] = this.toRequestPrincipalAwareMatcher(this.getRequestUtil()::isSecuredFlowRoute);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers(new RequestMatcher[]{this.defaultPermitMatcher()})).permitAll().requestMatchers(requestMatcherArray)).authenticated();
        if (EndpointRequestUtil.isHillaAvailable()) {
            RequestMatcher[] requestMatcherArray2 = new RequestMatcher[1];
            requestMatcherArray2[0] = this.toRequestPrincipalAwareMatcher(this.getRequestUtil()::isEndpointRequest);
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers(requestMatcherArray2)).authenticated();
        }
    }

    private ApplicationContext getApplicationContext() {
        return (ApplicationContext)((HttpSecurity)this.getBuilder()).getSharedObject(ApplicationContext.class);
    }

    private <T> void setSharedObject(Class<T> type, T object) {
        ((HttpSecurity)this.getBuilder()).setSharedObject(type, object);
    }

    private <T> Optional<T> getSharedObject(Class<T> type) {
        return Optional.ofNullable(((HttpSecurity)this.getBuilder()).getSharedObject(type));
    }

    private <T> T getSharedObjectOrBean(Class<T> type) {
        return (T)this.getSharedObject(type).orElseGet(() -> {
            ObjectProvider provider = this.getApplicationContext().getBeanProvider(type);
            Object bean = provider.getIfAvailable();
            if (bean != null) {
                ((HttpSecurity)this.getBuilder()).setSharedObject(type, bean);
            }
            return bean;
        });
    }
}

