/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.spring.RootMappedCondition;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.VaadinApplicationConfiguration;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import com.vaadin.flow.spring.VaadinServletConfiguration;
import com.vaadin.flow.spring.VaadinServletContextInitializer;
import com.vaadin.flow.spring.VaadinWebsocketEndpointExporter;
import com.vaadin.flow.spring.springnative.VaadinBeanFactoryInitializationAotProcessor;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.util.HashMap;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.webmvc.autoconfigure.WebMvcAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@ConditionalOnClass(value={ServletContextInitializer.class})
@EnableConfigurationProperties(value={VaadinConfigurationProperties.class})
@Import(value={VaadinApplicationConfiguration.class, VaadinServletConfiguration.class})
public class SpringBootAutoConfiguration {
    @Autowired
    private WebApplicationContext context;

    @Bean
    static VaadinBeanFactoryInitializationAotProcessor flowBeanFactoryInitializationAotProcessor() {
        return new VaadinBeanFactoryInitializationAotProcessor();
    }

    @Bean
    public ServletContextInitializer contextInitializer() {
        return new VaadinServletContextInitializer((ApplicationContext)this.context);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringServlet.class}, parameterizedContainer={ServletRegistrationBean.class})
    public ServletRegistrationBean<SpringServlet> servletRegistrationBean(ObjectProvider<MultipartConfigElement> multipartConfig, VaadinConfigurationProperties configurationProperties) {
        boolean rootMapping = RootMappedCondition.isRootMapping(configurationProperties.getUrlMapping());
        return SpringBootAutoConfiguration.configureServletRegistrationBean(multipartConfig, configurationProperties, new SpringServlet((ApplicationContext)this.context, rootMapping));
    }

    public static ServletRegistrationBean<SpringServlet> configureServletRegistrationBean(ObjectProvider<MultipartConfigElement> multipartConfig, VaadinConfigurationProperties configurationProperties, SpringServlet servletInstance) {
        String mapping = configurationProperties.getUrlMapping();
        boolean rootMapping = RootMappedCondition.isRootMapping(mapping);
        HashMap<String, Object> initParameters = new HashMap<String, Object>();
        if (rootMapping) {
            mapping = "/vaadinServlet/*";
            initParameters.put("VAADIN_SERVLET_VITE_DEV_MODE_FRONTEND_PATH", "");
        }
        Object pushUrl = rootMapping ? "" : mapping.replace("/*", "");
        pushUrl = (String)pushUrl + "/VAADIN/push";
        initParameters.put("org.atmosphere.container.JSR356AsyncSupport.mappingPath", pushUrl);
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servletInstance, new String[]{mapping});
        registration.setInitParameters(initParameters);
        registration.setAsyncSupported(configurationProperties.isAsyncSupported());
        registration.setName(ClassUtils.getShortNameAsProperty(SpringServlet.class));
        if (!rootMapping) {
            multipartConfig.ifAvailable(arg_0 -> ((ServletRegistrationBean)registration).setMultipartConfig(arg_0));
        }
        registration.setLoadOnStartup(configurationProperties.isLoadOnStartup() ? 1 : -1);
        registration.setMultipartConfig(new MultipartConfigElement((String)null));
        return registration;
    }

    @Bean
    public ServerEndpointExporter websocketEndpointDeployer() {
        return new VaadinWebsocketEndpointExporter();
    }
}

