/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.spring.AuthenticationUtil;
import com.vaadin.flow.spring.security.VaadinRolePrefixHolder;
import java.security.Principal;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;

class SecurityUtil {
    SecurityUtil() {
    }

    static Principal getPrincipal(VaadinRequest request) {
        boolean isWebsocketPush = SecurityUtil.isWebsocketPush(request);
        if (request == null || isWebsocketPush && request.getUserPrincipal() == null) {
            return AuthenticationUtil.getSecurityHolderAuthentication();
        }
        return request.getUserPrincipal();
    }

    static Predicate<String> getRolesChecker(VaadinRequest request) {
        boolean isWebsocketPush = SecurityUtil.isWebsocketPush(request);
        if (request == null || isWebsocketPush) {
            Principal principal;
            AtomicReference roleCheckerHolder = new AtomicReference();
            Runnable roleCheckerLookup = () -> roleCheckerHolder.set(Optional.ofNullable(request).map(VaadinRequest::getService).or(() -> Optional.ofNullable(VaadinService.getCurrent())).map(service -> (Lookup)service.getContext().getAttribute(Lookup.class)).map(lookup -> (VaadinRolePrefixHolder)lookup.lookup(VaadinRolePrefixHolder.class)).map(VaadinRolePrefixHolder::getRolePrefix).map(AuthenticationUtil::getSecurityHolderRoleChecker).orElseGet(AuthenticationUtil::getSecurityHolderRoleChecker));
            Authentication authentication = AuthenticationUtil.getSecurityHolderAuthentication();
            if (authentication == null && isWebsocketPush && (principal = request.getUserPrincipal()) instanceof Authentication) {
                Authentication requestAuthentication = (Authentication)principal;
                roleCheckerLookup = new DelegatingSecurityContextRunnable(roleCheckerLookup, (SecurityContext)new SecurityContextImpl(requestAuthentication));
            }
            roleCheckerLookup.run();
            return ((Function)roleCheckerHolder.get())::apply;
        }
        Optional.ofNullable(request.getService()).map(service -> (Lookup)service.getContext().getAttribute(Lookup.class)).map(lookup -> (VaadinRolePrefixHolder)lookup.lookup(VaadinRolePrefixHolder.class)).filter(prefixHolder -> !prefixHolder.isSet()).ifPresent(prefixHolder -> prefixHolder.resetRolePrefix(request));
        return arg_0 -> ((VaadinRequest)request).isUserInRole(arg_0);
    }

    private static boolean isWebsocketPush(VaadinRequest request) {
        return request != null && HandlerHelper.isRequestType((VaadinRequest)request, (HandlerHelper.RequestType)HandlerHelper.RequestType.PUSH) && "websocket".equals(request.getHeader("X-Atmosphere-Transport"));
    }
}

