/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="vaadin")
public class VaadinConfigurationProperties {
    private String urlMapping = "/*";
    private boolean asyncSupported = true;
    private boolean loadOnStartup = true;
    private Devmode devmode = new Devmode();
    private Pnpm pnpm = new Pnpm();
    private Bun bun = new Bun();
    private React react = new React();
    private Frontend frontend = new Frontend();
    private List<String> blockedPackages = new ArrayList<String>();
    private List<String> allowedPackages = new ArrayList<String>();
    private boolean launchBrowser = false;
    private int launchBrowserDelay = 30;
    private List<String> excludeUrls;
    private boolean devmodeCaching = true;

    public static String getUrlMapping(Environment environment) {
        return (String)Binder.get((Environment)environment).bind("vaadin", VaadinConfigurationProperties.class).map(conf -> conf.getUrlMapping()).orElse(null);
    }

    public static List<String> getExcludedUrls(Environment environment) {
        return (List)Binder.get((Environment)environment).bind("vaadin", VaadinConfigurationProperties.class).map(VaadinConfigurationProperties::getExcludeUrls).orElse(null);
    }

    public static List<String> getAllowedPackages(Environment environment) {
        return (List)Binder.get((Environment)environment).bind("vaadin", VaadinConfigurationProperties.class).map(VaadinConfigurationProperties::getAllowedPackages).orElse(Collections.emptyList());
    }

    public String getUrlMapping() {
        return this.urlMapping;
    }

    public void setUrlMapping(String urlMapping) {
        this.urlMapping = urlMapping;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public boolean isLaunchBrowser() {
        return this.launchBrowser;
    }

    public void setLaunchBrowser(boolean launchBrowser) {
        this.launchBrowser = launchBrowser;
    }

    public int getLaunchBrowserDelay() {
        return this.launchBrowserDelay;
    }

    public void setLaunchBrowserDelay(int launchBrowser) {
        this.launchBrowserDelay = launchBrowser;
    }

    public boolean isDevmodeCaching() {
        return this.devmodeCaching;
    }

    public void setDevmodeCaching(boolean devmodeCaching) {
        this.devmodeCaching = devmodeCaching;
    }

    public List<String> getBlockedPackages() {
        return Collections.unmodifiableList(this.blockedPackages);
    }

    public void setBlockedPackages(List<String> blockedPackages) {
        this.blockedPackages = blockedPackages;
    }

    public List<String> getAllowedPackages() {
        return this.allowedPackages;
    }

    public void setAllowedPackages(List<String> allowedPackages) {
        this.allowedPackages = allowedPackages;
    }

    public List<String> getExcludeUrls() {
        return this.excludeUrls;
    }

    public void setExcludeUrls(List<String> excludeUrls) {
        this.excludeUrls = excludeUrls;
    }

    public Devmode getDevmode() {
        return this.devmode;
    }

    public Pnpm getPnpm() {
        return this.pnpm;
    }

    public Bun getBun() {
        return this.bun;
    }

    public React getReact() {
        return this.react;
    }

    public Frontend getFrontend() {
        return this.frontend;
    }

    public static class Devmode {
        private String hostsAllowed = "";
        private String remoteAddressHeader;

        public String getHostsAllowed() {
            return this.hostsAllowed;
        }

        public void setHostsAllowed(String hostsAllowed) {
            this.hostsAllowed = hostsAllowed;
        }

        public String getRemoteAddressHeader() {
            return this.remoteAddressHeader;
        }

        public void setRemoteAddressHeader(String remoteAddressHeader) {
            this.remoteAddressHeader = remoteAddressHeader;
        }
    }

    public static class Pnpm {
        private boolean enable;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    public static class Bun {
        private boolean enable;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    public static class React {
        private boolean enable = true;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    public static class Frontend {
        private boolean hotdeploy = false;

        public boolean isHotdeploy() {
            return this.hotdeploy;
        }

        public void setHotdeploy(boolean hotdeploy) {
            this.hotdeploy = hotdeploy;
        }
    }
}

