/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.io;

import com.vaadin.flow.internal.FileIOUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class FilterableResourceResolver
extends PathMatchingResourcePatternResolver
implements Serializable {
    private static final String JAR_PROTOCOL = "jar:";
    private static final String JAR_KEY = ".jar!/";
    private static final String JAR_EXTENSION = ".jar";
    private static final String PACKAGE_PROPERTIES_PATH = "META-INF/VAADIN/package.properties";
    private static final String BLOCKED_JARS_LIST_PATH = "/META-INF/VAADIN/blocked-jars.list";
    public static final String ALLOWED_PACKAGES_PROPERTY = "vaadin.allowed-packages";
    public static final String BLOCKED_PACKAGES_PROPERTY = "vaadin.blocked-packages";
    public static final String BLOCKED_JAR_PROPERTY = "vaadin.blocked-jar";
    private static final List<String> DEFAULT_SCAN_NEVER_JAR = Stream.of("antlr", "logback-classic", "logback-classic-core", "commons-codec-*.*.*.jar", "commons-fileupload", "commons-io-*.*.*.jar", "commons-logging", "commons-exec", "commons-lang*-*.*.*.jar", "jackson-databind-", "jackson-core-", "jackson-datatype-", "jackson-annotations-", "jackson-module-", "jackson-datatype-", "atmosphere-runtime", "byte-buddy", "commons-compress", "aspectjweaver", "hibernate-core", "hibernate-commons", "hibernate-validator", "jboss-logging", "selenium-", "slf4j-simple-", "slf4j-api-", "spring-*.*.*.jar", "spring-webmvc-*.*.*.jar", "spring-aop-*.*.*.jar", "spring-beans-*.*.*.jar", "spring-context-*.*.*.jar", "spring-core-*.*.*.jar", "spring-jcl-*.*.*.jar", "spring-expression-*.*.*.jar", "spring-websocket-*.*.*.jar", "spring-web-*.*.*.jar", "snakeyaml-*.*.jar", "javax.", "jakarta.", "kotlin-reflect-", "kotlin-stdlib-", "gwt-elemental", "javassist-*.*.*-*.jar", "javaparser-core-*.*.*.jar", "javaparser-symbol", "oshi-core-*.*.*.jar", "micrometer-observation-*.*.*.jar", "micrometer-commons-*.*.*.jar", "nimbus-jose-jwt", "jooq-*.*.*.jar", "jooq-*-*.*.*.jar", "directory-watcher-*.*.*.jar", "classgraph", "jsoup-*.*.*.jar", "throw-if-servlet3", "ph-css-*.*.*.jar", "ph-commons-*.*.*.jar", "gentyref-*.*.*.vaadin1.jar", "asm-*.*.jar", "asm-commons-*.*.jar", "asm-tree-*.*.jar", "jetty-", "tomcat-", "classmate-*.*.*.jar", "reflections-*.*.*.jar", "jna-*.*.*.jar", "jna-platform-*.*.*.jar", "jcip-annotations-*.*.*.jar", "activation-*.*.*.jar", "httpcore5-*.*.*.jar", "httpcore5-h2-*.*.*.jar", "hilla-engine-core-", "hilla-engine-runtime-", "hilla-parser-jvm-", "hilla-runtime-plugin-").toList();
    private final Map<String, PackageInfo> propertiesCache = new HashMap<String, PackageInfo>();
    private List<String> blockedJarsList;

    public FilterableResourceResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
        this.initBlockedJars();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FilterableResourceResolver.class);
    }

    private String toJarPath(String path) {
        return path.substring(0, path.lastIndexOf(JAR_KEY) + JAR_KEY.length());
    }

    private String pathToKey(String path) {
        String key = path.substring(0, path.lastIndexOf(JAR_KEY));
        if (key.startsWith(JAR_PROTOCOL)) {
            key = key.substring(4);
        }
        return key;
    }

    protected boolean isJar(String path) {
        return path.lastIndexOf(JAR_KEY) != -1;
    }

    private Resource doResolveRootDirResource(Resource original) throws IOException {
        int index;
        String rootDirPath = original.getURI().getPath();
        if (rootDirPath == null) {
            rootDirPath = original.getURI().toString();
        }
        if (rootDirPath != null && (index = rootDirPath.lastIndexOf(JAR_KEY)) != -1) {
            String jarPath = rootDirPath.substring(0, index + JAR_KEY.length());
            return new UrlResource(jarPath);
        }
        return super.resolveRootDirResource(original);
    }

    protected Set<Resource> doFindPathMatchingJarResources(Resource rootDirResource, URL rootDirUrl, String subPattern) throws IOException {
        String path = rootDirResource.getURI().toString();
        String jarName = this.resolveJarName(rootDirResource.getURI());
        if (jarName != null && this.blockedJarsList.stream().anyMatch(pattern -> this.jarNamePatternMatch(jarName, (String)pattern))) {
            return Set.of();
        }
        String key = this.cachePackageProperties(path, rootDirResource, rootDirUrl);
        if (this.isBlockedJar(rootDirResource, key)) {
            return Collections.emptySet();
        }
        return super.doFindPathMatchingJarResources(rootDirResource, rootDirUrl, subPattern);
    }

    protected Set<Resource> doFindAllClassPathResources(String path) throws IOException {
        Set result = super.doFindAllClassPathResources(path);
        result.removeIf(res -> {
            try {
                String jarName = this.resolveJarName(res.getURI());
                if (jarName != null && this.blockedJarsList.stream().anyMatch(pattern -> this.jarNamePatternMatch(jarName, (String)pattern))) {
                    return true;
                }
            }
            catch (IOException e) {
                FilterableResourceResolver.getLogger().warn("Failed to resolve path for resource {}", res, (Object)e);
            }
            String key = this.cachePackageProperties((Resource)res);
            return this.isBlockedJar((Resource)res, key);
        });
        return result;
    }

    boolean jarNamePatternMatch(String jarName, String pattern) {
        if (pattern.contains("*")) {
            if (pattern.equals("*")) {
                return true;
            }
            String[] parts = pattern.split("\\*");
            String remainingName = jarName;
            int nextPartIndex = 0;
            int partIndex = 0;
            for (String part : parts) {
                if (!remainingName.startsWith(part)) {
                    return false;
                }
                if (partIndex + 1 >= parts.length) {
                    return true;
                }
                nextPartIndex = (remainingName = remainingName.substring(part.length())).indexOf(parts[partIndex + 1]);
                if (nextPartIndex == -1) {
                    return false;
                }
                if (remainingName.substring(0, nextPartIndex).contains("-")) {
                    return false;
                }
                remainingName = remainingName.substring(nextPartIndex);
                ++partIndex;
            }
        }
        return jarName.startsWith(pattern);
    }

    private String resolveJarName(URI resourceURI) {
        int index;
        String resourcePath = resourceURI.getPath();
        if (resourcePath == null) {
            resourcePath = resourceURI.toString();
        }
        if ((index = resourcePath.lastIndexOf(JAR_EXTENSION)) > -1) {
            String jarName = resourcePath.substring(0, index + JAR_EXTENSION.length());
            if ((index = jarName.lastIndexOf("/")) > -1) {
                return jarName.substring(index + 1);
            }
            return jarName;
        }
        return null;
    }

    private String cachePackageProperties(String path, Resource rootDirResource, URL rootDirUrl) throws IOException {
        String key = path;
        if (this.isJar(path)) {
            key = this.pathToKey(path);
            if (!this.propertiesCache.containsKey(key)) {
                this.propertiesCache.put(key, this.readPackageProperties(rootDirUrl, path, this.doResolveRootDirResource(rootDirResource)));
                FilterableResourceResolver.getLogger().trace("Caching package.properties of JAR {}", (Object)path);
            }
        } else if (!this.propertiesCache.containsKey(path)) {
            Resource resource = this.doFindPathMatchingFileResources(rootDirResource, PACKAGE_PROPERTIES_PATH).stream().findFirst().orElse(null);
            Properties properties = resource != null ? PropertiesLoaderUtils.loadProperties((Resource)resource) : null;
            this.propertiesCache.put(path, this.createPackageInfo(properties));
            FilterableResourceResolver.getLogger().trace("Caching package.properties of directory {}", (Object)path);
        }
        return key;
    }

    private String cachePackageProperties(Resource res) {
        String key = null;
        try {
            String rootPath;
            Resource rootDirResource = this.convertClassLoaderURL(res.getURL());
            String rootDirPath = rootDirResource.getURI().toString();
            key = rootPath = rootDirResource.getURI().getPath();
            if (rootPath != null && this.isJar(rootDirPath)) {
                String jarPath = this.toJarPath(rootDirPath);
                key = this.pathToKey(rootPath);
                if (!this.propertiesCache.containsKey(key)) {
                    this.propertiesCache.put(key, this.readPackageProperties(null, jarPath, rootDirResource));
                    FilterableResourceResolver.getLogger().trace("Caching package.properties of JAR {}", (Object)rootPath);
                }
            } else if (!this.propertiesCache.containsKey(rootPath)) {
                Resource resource = this.doFindPathMatchingFileResources(rootDirResource, PACKAGE_PROPERTIES_PATH).stream().findFirst().orElse(null);
                Properties properties = resource != null ? PropertiesLoaderUtils.loadProperties((Resource)resource) : null;
                this.propertiesCache.put(rootPath, this.createPackageInfo(properties));
                FilterableResourceResolver.getLogger().trace("Caching package.properties of directory {}", (Object)rootPath);
            }
        }
        catch (IOException e) {
            FilterableResourceResolver.getLogger().warn("Failed to find {} for path {}", new Object[]{PACKAGE_PROPERTIES_PATH, res, e});
        }
        return key;
    }

    protected boolean isBlockedJar(Resource resource, String key) {
        if (resource != null && key != null) {
            PackageInfo pkgInfo = this.propertiesCache.get(key);
            return pkgInfo != null && pkgInfo.blockedJar();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageInfo readPackageProperties(URL jarPathURL, String jarPath, Resource rootDirResource) throws IOException {
        boolean closeJarFile;
        JarFile jarFile;
        URLConnection con = null;
        String urlFile = null;
        if (jarPathURL != null) {
            con = jarPathURL.openConnection();
            urlFile = jarPathURL.getPath();
        }
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarFile = jarCon.getJarFile();
            closeJarFile = !jarCon.getUseCaches();
        } else {
            urlFile = urlFile != null ? urlFile : jarPath;
            try {
                int separatorIndex = urlFile.indexOf("*/");
                if (separatorIndex == -1) {
                    separatorIndex = urlFile.indexOf("!/");
                }
                if (separatorIndex != -1) {
                    String jarFileUrl = urlFile.substring(0, separatorIndex);
                    jarFile = this.getJarFile(jarFileUrl);
                } else {
                    jarFile = new JarFile(urlFile);
                }
                closeJarFile = true;
            }
            catch (ZipException ex) {
                if (FilterableResourceResolver.getLogger().isDebugEnabled()) {
                    FilterableResourceResolver.getLogger().debug("Skipping invalid jar class path entry [" + urlFile + "]");
                }
                return null;
            }
        }
        try {
            if (FilterableResourceResolver.getLogger().isTraceEnabled()) {
                FilterableResourceResolver.getLogger().trace("Looking for package.properties in jar file [" + String.valueOf(rootDirResource) + "]");
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Properties prop;
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.endsWith(PACKAGE_PROPERTIES_PATH)) continue;
                Resource resource = this.doFindPathMatchingFileResources(rootDirResource, PACKAGE_PROPERTIES_PATH).stream().findFirst().orElseGet(() -> {
                    try {
                        return rootDirResource.createRelative(PACKAGE_PROPERTIES_PATH);
                    }
                    catch (IOException e) {
                        FilterableResourceResolver.getLogger().warn("Could not read package.properties", (Throwable)e);
                        return null;
                    }
                });
                Properties properties = prop = resource != null ? PropertiesLoaderUtils.loadProperties((Resource)resource) : null;
                if (FilterableResourceResolver.getLogger().isTraceEnabled()) {
                    FilterableResourceResolver.getLogger().trace("Read package.properties: [{}]", (Object)prop);
                }
                PackageInfo packageInfo = prop != null ? this.createPackageInfo(prop) : null;
                return packageInfo;
            }
            PackageInfo packageInfo = null;
            return packageInfo;
        }
        finally {
            if (closeJarFile) {
                jarFile.close();
            }
        }
    }

    protected boolean isAllowedByPackageProperties(String rootPath, String targetPath, boolean defaultValue) {
        PackageInfo packageInfo = this.propertiesCache.get(rootPath);
        if (packageInfo == null) {
            return defaultValue;
        }
        if (!packageInfo.allowedPackages().isEmpty()) {
            return packageInfo.allowedPackages().stream().anyMatch(targetPath::startsWith);
        }
        if (!packageInfo.blockedPackages().isEmpty()) {
            return packageInfo.blockedPackages().stream().noneMatch(targetPath::startsWith);
        }
        return defaultValue;
    }

    private PackageInfo createPackageInfo(Properties properties) {
        if (properties == null) {
            return null;
        }
        Set<String> allowedPackages = Stream.of(properties.getProperty(ALLOWED_PACKAGES_PROPERTY, "").split(",")).filter(pkg -> !pkg.isBlank()).map(String::trim).map(pkg -> pkg.replace(".", "/")).collect(Collectors.toSet());
        Set<String> blockedPackages = Stream.of(properties.getProperty(BLOCKED_PACKAGES_PROPERTY, "").split(",")).filter(pkg -> !pkg.isBlank()).map(String::trim).map(pkg -> pkg.replace(".", "/")).collect(Collectors.toSet());
        boolean blockedJar = Boolean.parseBoolean(properties.getProperty(BLOCKED_JAR_PROPERTY, "false"));
        return new PackageInfo(allowedPackages, blockedPackages, blockedJar);
    }

    private void initBlockedJars() {
        this.blockedJarsList = DEFAULT_SCAN_NEVER_JAR;
        URL url = this.getClass().getResource(BLOCKED_JARS_LIST_PATH);
        if (url == null) {
            return;
        }
        try {
            String content = FileIOUtils.urlToString((URL)url);
            if (content != null) {
                this.blockedJarsList = content.isBlank() ? Collections.emptyList() : Arrays.asList(content.split("\\R"));
            }
        }
        catch (IOException e) {
            FilterableResourceResolver.getLogger().error("Failed to read {}. Falling back to default list of blocked jars.", (Object)BLOCKED_JARS_LIST_PATH, (Object)e);
        }
    }

    private record PackageInfo(Set<String> allowedPackages, Set<String> blockedPackages, boolean blockedJar) implements Serializable
    {
    }
}

