/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.springnative;

import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.router.MenuData;
import com.vaadin.flow.router.internal.DefaultErrorHandler;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.menu.RouteParamType;
import com.vaadin.flow.shared.ui.Dependency;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class VaadinHintsRegistrar
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        ReflectionHints ref = hints.reflection();
        LookupInitializer.getDefaultImplementations().forEach(cls -> ref.registerType(cls, MemberCategory.values()));
        hints.resources().registerPattern("META-INF/VAADIN/**");
        hints.resources().registerPattern("vaadin-i18n/*");
        hints.resources().registerPattern("vaadin-featureflags.properties");
        for (String cls2 : this.getClasses()) {
            hints.reflection().registerType(TypeReference.of((String)cls2), MemberCategory.values());
        }
        for (String componentClass : this.getCommonComponentClasses()) {
            hints.reflection().registerType(TypeReference.of((String)componentClass), MemberCategory.values());
        }
        this.registerResourceIfPresent(hints, "com/vaadin/flow/component/login/i18n.json");
        this.registerResourceIfPresent(hints, "com/vaadin/flow/component/crud/i18n.json");
        hints.resources().registerPattern("com/vaadin/flow/server/**");
        hints.resources().registerPattern("com/vaadin/flow/router/**");
    }

    private void registerResourceIfPresent(RuntimeHints hints, String path) {
        ClassPathResource res = new ClassPathResource(path);
        if (res.exists()) {
            hints.resources().registerResource((Resource)res);
        }
    }

    private Set<String> getCommonComponentClasses() {
        HashSet<String> classes = new HashSet<String>(List.of("com.vaadin.flow.component.messages.MessageListItem"));
        Predicate<String> i18nClasses = className -> className.matches(".*I18[nN]($|\\$.*$)");
        Predicate<String> componentsFilter = i18nClasses.or(className -> className.startsWith("com.vaadin.flow.component.charts.model.") || className.startsWith("com.vaadin.flow.component.map.configuration."));
        classes.addAll(VaadinHintsRegistrar.classesFromPackage("com.vaadin.flow.component", componentsFilter));
        return classes;
    }

    private static Set<String> classesFromPackage(String packageName, Predicate<String> filter) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(".*")));
        Set classes = provider.findCandidateComponents(packageName);
        return classes.stream().map(beanDefinition -> beanDefinition.getBeanClassName()).collect(Collectors.toSet());
    }

    private String[] getClasses() {
        return new String[]{"org.apache.catalina.core.ApplicationContextFacade", "org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler$SupplierCsrfToken", "org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter", "org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper", "tools.jackson.databind.ser.std.ToStringSerializer", DefaultErrorHandler.class.getName(), MenuData.class.getName(), AvailableViewInfo.class.getName(), AvailableViewInfo.DetailDeserializer.class.getName(), AvailableViewInfo.DetailSerializer.class.getName(), RouteParamType.class.getName(), Dependency.class.getName()};
    }
}

