/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.server.auth.AccessPathChecker;
import com.vaadin.flow.spring.security.RequestUtil;
import java.security.Principal;
import java.util.function.Predicate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;

public class SpringAccessPathChecker
implements AccessPathChecker {
    private final transient WebInvocationPrivilegeEvaluator evaluator;
    private final String urlMapping;

    public SpringAccessPathChecker(WebInvocationPrivilegeEvaluator evaluator) {
        this(evaluator, null);
    }

    public SpringAccessPathChecker(WebInvocationPrivilegeEvaluator evaluator, String urlMapping) {
        this.urlMapping = urlMapping;
        this.evaluator = evaluator;
    }

    public boolean hasAccess(String path, Principal principal, Predicate<String> roleChecker) {
        path = RequestUtil.applyUrlMapping(this.urlMapping, path);
        return this.evaluator.isAllowed(path, SecurityContextHolder.getContext().getAuthentication());
    }
}

