/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.scopes;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.spring.scopes.AbstractScope;
import com.vaadin.flow.spring.scopes.BeanStore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;

public class VaadinUIScope
extends AbstractScope {
    public static final String VAADIN_UI_SCOPE_NAME = "vaadin-ui";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope(VAADIN_UI_SCOPE_NAME, (Scope)this);
        ObjectFactory factory = this::getUI;
        beanFactory.registerResolvableDependency(UI.class, (Object)factory);
    }

    public String getConversationId() {
        return this.getVaadinSession().getSession().getId() + "-UI:" + this.getUI().getUIId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BeanStore getBeanStore() {
        VaadinSession session = this.getVaadinSession();
        session.getLockInstance().lock();
        try {
            UIStoreWrapper wrapper = (UIStoreWrapper)session.getAttribute(UIStoreWrapper.class);
            if (wrapper == null) {
                wrapper = new UIStoreWrapper(session);
                session.setAttribute(UIStoreWrapper.class, (Object)wrapper);
            }
            BeanStore beanStore = wrapper.getBeanStore(this.getUI());
            return beanStore;
        }
        finally {
            session.getLockInstance().unlock();
        }
    }

    private UI getUI() {
        return UI.getCurrentOrThrow();
    }

    private static class UIStoreWrapper
    implements ComponentEventListener<DetachEvent> {
        private final VaadinSession session;
        private final Map<Integer, BeanStore> uiStores;

        private UIStoreWrapper(VaadinSession session) {
            assert (session.hasLock());
            this.uiStores = new HashMap<Integer, BeanStore>();
            this.session = session;
            session.addSessionDestroyListener((SessionDestroyListener & Serializable)event -> this.destroy());
        }

        public void onComponentEvent(DetachEvent event) {
            BeanStore beanStore;
            assert (this.session.hasLock());
            UI ui = event.getUI();
            if (ui.isClosing() && (beanStore = this.uiStores.remove(ui.getUIId())) != null) {
                beanStore.destroy();
            }
        }

        BeanStore getBeanStore(UI ui) {
            BeanStore beanStore = this.uiStores.get(ui.getUIId());
            if (beanStore == null) {
                beanStore = new BeanStore(this.session);
                this.uiStores.put(ui.getUIId(), beanStore);
                ui.addDetachListener((ComponentEventListener)this);
            }
            return beanStore;
        }

        private void destroy() {
            this.session.lock();
            try {
                this.session.setAttribute(UIStoreWrapper.class, null);
                this.uiStores.values().forEach(BeanStore::destroy);
                this.uiStores.clear();
            }
            finally {
                this.session.unlock();
            }
        }
    }
}

