/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.internal.springcsrf.SpringCsrfTokenUtil;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Optional;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

public class VaadinSavedRequestAwareAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static final String SOURCE_HEADER = "source";
    private static final String RESULT_HEADER = "Result";
    private static final String DEFAULT_URL_HEADER = "Default-url";
    private static final String SAVED_URL_HEADER = "Saved-url";
    private static final String SPRING_CSRF_HEADER = "Spring-CSRF-header";
    private static final String SPRING_CSRF_TOKEN = "Spring-CSRF-token";
    private RequestCache requestCache = new HttpSessionRequestCache();
    private CsrfTokenRepository csrfTokenRepository;

    public VaadinSavedRequestAwareAuthenticationSuccessHandler() {
        this.setRedirectStrategy((org.springframework.security.web.RedirectStrategy)new RedirectStrategy());
        this.setTargetUrlParameter(SAVED_URL_HEADER);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        if (VaadinSavedRequestAwareAuthenticationSuccessHandler.isTypescriptLogin(request)) {
            response.setHeader(DEFAULT_URL_HEADER, this.determineTargetUrl(request, response));
            if (this.csrfTokenRepository != null) {
                CsrfToken csrfToken2 = this.csrfTokenRepository.generateToken(request);
                this.csrfTokenRepository.saveToken(csrfToken2, request, response);
                response.setHeader(SPRING_CSRF_HEADER, csrfToken2.getHeaderName());
                response.setHeader(SPRING_CSRF_TOKEN, csrfToken2.getToken());
            } else {
                Optional springCsrfToken = SpringCsrfTokenUtil.getSpringCsrfToken((ServletRequest)request);
                springCsrfToken.ifPresent(csrfToken -> {
                    response.setHeader(SPRING_CSRF_HEADER, csrfToken.getHeaderName());
                    response.setHeader(SPRING_CSRF_TOKEN, csrfToken.getToken());
                });
            }
        } else if (this.csrfTokenRepository != null) {
            this.csrfTokenRepository.saveToken(null, request, response);
        }
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String fullySavedRequestUrl = VaadinSavedRequestAwareAuthenticationSuccessHandler.getStoredServerNavigation(request);
        if (savedRequest != null) {
            String targetUrlParameter = this.getTargetUrlParameter();
            if (!(this.isAlwaysUseDefaultTargetUrl() || targetUrlParameter != null && StringUtils.hasText((String)request.getParameter(targetUrlParameter)))) {
                this.clearAuthenticationAttributes(request);
                String targetUrl = savedRequest.getRedirectUrl();
                response.setHeader(SAVED_URL_HEADER, targetUrl);
                this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
                return;
            }
            this.requestCache.removeRequest(request, response);
        } else if (fullySavedRequestUrl != null) {
            response.setHeader(SAVED_URL_HEADER, fullySavedRequestUrl);
        }
        super.onAuthenticationSuccess(request, response, authentication);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String targetUrl;
        if (!this.isAlwaysUseDefaultTargetUrl() && this.getTargetUrlParameter() != null && StringUtils.hasText((String)(targetUrl = response.getHeader(this.getTargetUrlParameter())))) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Using url %s from response header %s", (Object)targetUrl, (Object)this.getTargetUrlParameter()));
            }
            return targetUrl;
        }
        return super.determineTargetUrl(request, response);
    }

    private static String getStoredServerNavigation(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String redirectUrl = (String)session.getAttribute(NavigationAccessControl.SESSION_STORED_REDIRECT_ABSOLUTE);
        session.removeAttribute(NavigationAccessControl.SESSION_STORED_REDIRECT_ABSOLUTE);
        return redirectUrl;
    }

    static boolean isTypescriptLogin(HttpServletRequest request) {
        return "typescript".equals(request.getHeader(SOURCE_HEADER));
    }

    public void setRequestCache(RequestCache requestCache) {
        super.setRequestCache(requestCache);
        this.requestCache = requestCache;
    }

    public void setCsrfTokenRepository(CsrfTokenRepository csrfTokenRepository) {
        this.csrfTokenRepository = csrfTokenRepository;
    }

    public static class RedirectStrategy
    extends DefaultRedirectStrategy {
        public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
            if (!VaadinSavedRequestAwareAuthenticationSuccessHandler.isTypescriptLogin(request)) {
                super.sendRedirect(request, response, url);
                return;
            }
            response.setHeader(VaadinSavedRequestAwareAuthenticationSuccessHandler.RESULT_HEADER, "success");
        }
    }
}

