/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.spring.SpringInstantiator;
import com.vaadin.flow.spring.annotation.VaadinTaskExecutor;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;

public class SpringVaadinServletService
extends VaadinServletService {
    private final transient ApplicationContext context;
    static final String SPRING_BOOT_WEBPROPERTIES_CLASS = "org.springframework.boot.autoconfigure.web.WebProperties";
    private Set<String> multipleExecutorCandidates;

    public SpringVaadinServletService(VaadinServlet servlet, DeploymentConfiguration deploymentConfiguration, ApplicationContext context) {
        super(servlet, deploymentConfiguration);
        this.context = context;
    }

    protected Optional<Instantiator> loadInstantiators() throws ServiceException {
        Optional spiInstantiator = super.loadInstantiators();
        List springInstantiators = this.context.getBeansOfType(Instantiator.class).values().stream().collect(Collectors.toList());
        if (spiInstantiator.isPresent() && !springInstantiators.isEmpty()) {
            throw new ServiceException("Cannot init VaadinService because there are multiple eligible instantiator implementations: Java SPI registered instantiator " + String.valueOf(spiInstantiator.get()) + " and Spring instantiator beans: " + String.valueOf(springInstantiators));
        }
        if (!spiInstantiator.isPresent() && springInstantiators.isEmpty()) {
            SpringInstantiator defaultInstantiator = new SpringInstantiator((VaadinService)this, this.context);
            return Optional.of(defaultInstantiator);
        }
        return spiInstantiator.isPresent() ? spiInstantiator : springInstantiators.stream().findFirst();
    }

    protected Executor createDefaultExecutor() {
        Map<Boolean, List<String>> byType;
        Set candidates = Arrays.stream(this.context.getBeanNamesForType(TaskExecutor.class)).collect(Collectors.toCollection(HashSet::new));
        if (candidates.isEmpty()) {
            return super.createDefaultExecutor();
        }
        HashSet<String> annotatedBeans = new HashSet<String>(Set.of(this.context.getBeanNamesForAnnotation(VaadinTaskExecutor.class)));
        Set invalidAnnotatedTypes = annotatedBeans.stream().filter(beanName -> !candidates.contains(beanName)).collect(Collectors.toSet());
        if (!invalidAnnotatedTypes.isEmpty()) {
            LoggerFactory.getLogger((String)SpringVaadinServletService.class.getName()).warn("Found beans with @{} annotation but not of type {}: {}. Remove the annotation from the bean definition.", new Object[]{VaadinTaskExecutor.class.getSimpleName(), TaskExecutor.class.getSimpleName(), invalidAnnotatedTypes});
            annotatedBeans.removeAll(invalidAnnotatedTypes);
        }
        if (candidates.contains("VaadinTaskExecutor") || !annotatedBeans.isEmpty()) {
            candidates.removeIf(name -> !annotatedBeans.contains(name) && !name.equals("VaadinTaskExecutor"));
        }
        if (candidates.size() > 1 && !(byType = candidates.stream().collect(Collectors.partitioningBy(name -> this.context.isTypeMatch(name, TaskScheduler.class)))).get(true).isEmpty() && !byType.get(false).isEmpty()) {
            byType.get(true).forEach(candidates::remove);
        }
        if (candidates.size() > 1) {
            candidates.remove("applicationTaskExecutor");
        }
        if (candidates.size() > 1) {
            this.multipleExecutorCandidates = candidates;
        }
        return (Executor)this.context.getBean((String)candidates.iterator().next(), TaskExecutor.class);
    }

    public Executor getExecutor() {
        if (this.multipleExecutorCandidates != null) {
            String message = String.format("Multiple TaskExecutor beans found: %s. Please resolve this conflict by either: (1) Providing a single TaskExecutor bean, or (2) Marking the bean to use with Vaadin by: naming it '%s' (e.g. @Bean(\"%s\")), or applying the @%s qualifier annotation to the bean definition.", this.multipleExecutorCandidates, "VaadinTaskExecutor", "VaadinTaskExecutor", VaadinTaskExecutor.class.getSimpleName());
            throw new IllegalStateException(message);
        }
        return super.getExecutor();
    }

    public void init() throws ServiceException {
        super.init();
        Map uiInitListeners = this.context.getBeansOfType(UIInitListener.class);
        uiInitListeners.values().forEach(arg_0 -> ((SpringVaadinServletService)this).addUIInitListener(arg_0));
    }

    public URL getStaticResource(String path) {
        URL resource = super.getStaticResource(path);
        if (resource == null) {
            resource = this.getResourceURL(path);
        }
        return resource;
    }

    private URL getResourceURL(String path) {
        if (!this.isSpringBootConfigured()) {
            return null;
        }
        for (String prefix : ((WebProperties)this.context.getBean(WebProperties.class)).getResources().getStaticLocations()) {
            Resource resource = this.context.getResource(this.getFullPath(path, prefix));
            if (resource == null || !resource.exists()) continue;
            try {
                URI uri = resource.getURI();
                if (uri.isOpaque() && resource.isFile()) {
                    return resource.getFile().getAbsoluteFile().toURI().toURL();
                }
                return resource.getURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getFullPath(String path, String prefix) {
        if (prefix.endsWith("/") && path.startsWith("/")) {
            return prefix + path.substring(1);
        }
        return prefix + path;
    }

    private boolean isSpringBootConfigured() {
        Class<?> resourcesClass = SpringVaadinServletService.resolveClass(SPRING_BOOT_WEBPROPERTIES_CLASS);
        if (resourcesClass != null) {
            return this.context.getBeanNamesForType(resourcesClass).length != 0;
        }
        return false;
    }

    private static Class<?> resolveClass(String clazzName) {
        try {
            return Class.forName(clazzName, false, SpringVaadinServletService.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }
}

