/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

class ReloadEvent
implements Serializable {
    private final Set<String> addedClasses = new HashSet<String>();
    private final Set<String> changedClasses = new HashSet<String>();
    private final Set<String> removedClasses = new HashSet<String>();

    ReloadEvent() {
    }

    public Set<String> getAddedClasses() {
        return this.addedClasses;
    }

    public Set<String> getChangedClasses() {
        return this.changedClasses;
    }

    public Set<String> getRemovedClasses() {
        return this.removedClasses;
    }

    public Set<String> getAddedPackages() {
        return this.extractPackageNames(this.addedClasses);
    }

    public Set<String> getChangedPackages() {
        return this.extractPackageNames(this.changedClasses);
    }

    private Set<String> extractPackageNames(Set<String> classNames) {
        return classNames.stream().map(name -> name.contains(".") ? name.substring(0, name.lastIndexOf(".")) : name).collect(Collectors.toSet());
    }
}

