/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.spring.RootMappedCondition;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.SpringUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.ServletForwardingController;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@Conditional(value={RootMappedCondition.class})
public class VaadinServletConfiguration {
    static final String VAADIN_SERVLET_MAPPING = "/vaadinServlet/*";
    public static final String EXCLUDED_URLS_PROPERTY = "vaadin.excludeUrls";

    private static List<String> getExcludedUrls(Environment environment) {
        if (SpringUtil.isSpringBoot()) {
            try {
                return (List)Class.forName("com.vaadin.flow.spring.VaadinConfigurationProperties").getMethod("getExcludedUrls", Environment.class).invoke(null, environment);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LoggerFactory.getLogger(RootMappedCondition.class).error("Unable to find excluded URLs from properties", (Throwable)e);
                return null;
            }
        }
        String value = environment.getProperty(EXCLUDED_URLS_PROPERTY);
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split(",")).map(url -> url.trim()).collect(Collectors.toList());
    }

    @Bean
    public RootExcludeHandler vaadinRootMapping(Environment environment, @Autowired(required=false) @Qualifier(value="resourceHandlerMapping") HandlerMapping resourceHandlerMapping) {
        return new RootExcludeHandler(VaadinServletConfiguration.getExcludedUrls(environment), this.vaadinForwardingController(), resourceHandlerMapping);
    }

    @Bean
    public Controller vaadinForwardingController() {
        ServletForwardingController controller = new ServletForwardingController();
        controller.setServletName(ClassUtils.getShortNameAsProperty(SpringServlet.class));
        return controller;
    }

    public static class RootExcludeHandler
    extends SimpleUrlHandlerMapping {
        private List<String> excludeUrls;
        private AntPathMatcher matcher;
        private UrlPathHelper urlPathHelper = new UrlPathHelper();
        private HandlerMapping resourceHandlerMapping;

        public RootExcludeHandler(List<String> excludeUrls, Controller vaadinForwardingController, HandlerMapping resourceHandlerMapping) {
            this.excludeUrls = excludeUrls;
            this.resourceHandlerMapping = resourceHandlerMapping;
            this.matcher = new AntPathMatcher();
            this.setOrder(0x7FFFFFFE);
            this.setUrlMap(Collections.singletonMap("/**", vaadinForwardingController));
        }

        protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
            ResourceHttpRequestHandler resourceHttpRequestHandler;
            Object innerHandler;
            HandlerExecutionChain handler;
            if (this.excludeUrls != null && !this.excludeUrls.isEmpty()) {
                String requestPath = this.urlPathHelper.getPathWithinApplication(request);
                for (String pattern : this.excludeUrls) {
                    if (!this.matcher.match(pattern, requestPath)) continue;
                    this.getLogger().debug("Ignoring request to {} excluded by {}", (Object)requestPath, (Object)pattern);
                    return null;
                }
            }
            if (this.resourceHandlerMapping != null && (handler = this.resourceHandlerMapping.getHandler(request)) != null && (innerHandler = handler.getHandler()) instanceof ResourceHttpRequestHandler && !this.mapsToRoot(resourceHttpRequestHandler = (ResourceHttpRequestHandler)innerHandler)) {
                return handler;
            }
            return super.getHandlerInternal(request);
        }

        private boolean mapsToRoot(ResourceHttpRequestHandler resourceHttpRequestHandler) {
            return resourceHttpRequestHandler.getLocations().stream().anyMatch(location -> {
                ServletContextResource servletContextResource;
                return location instanceof ServletContextResource && "/".equals((servletContextResource = (ServletContextResource)location).getPath());
            });
        }

        protected Logger getLogger() {
            return LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
    }
}

