/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.spring.RootMappedCondition;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import jakarta.servlet.ServletContext;
import java.io.Serializable;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class DevModeBrowserLauncher
implements SpringApplicationRunListener,
Serializable {
    public DevModeBrowserLauncher(SpringApplication application, String[] arguments) {
    }

    public void ready(ConfigurableApplicationContext context, Duration timeTaken) {
        try {
            VaadinConfigurationProperties properties = (VaadinConfigurationProperties)context.getBean(VaadinConfigurationProperties.class);
            this.maybeLaunchBrowserInDevelopmentMode((ApplicationContext)context, properties.isLaunchBrowser());
        }
        catch (Exception e) {
            DevModeBrowserLauncher.getLogger().debug("Failed to launch browser", (Throwable)e);
        }
    }

    private void maybeLaunchBrowserInDevelopmentMode(ApplicationContext appContext, boolean launch) {
        if (!(appContext instanceof GenericWebApplicationContext)) {
            DevModeBrowserLauncher.getLogger().warn("Unable to determine production mode for an Spring Boot application context of type " + appContext.getClass().getName());
            return;
        }
        GenericWebApplicationContext webAppContext = (GenericWebApplicationContext)appContext;
        ServletContext servletContext = webAppContext.getServletContext();
        VaadinServletContext vaadinContext = new VaadinServletContext(servletContext);
        Lookup lookup = (Lookup)vaadinContext.getAttribute(Lookup.class);
        DevModeHandlerManager devModeHandlerManager = (DevModeHandlerManager)lookup.lookup(DevModeHandlerManager.class);
        if (devModeHandlerManager != null) {
            String url = DevModeBrowserLauncher.getUrl(webAppContext);
            devModeHandlerManager.setApplicationUrl(url);
            if (launch) {
                devModeHandlerManager.launchBrowserInDevelopmentMode(url);
            }
        }
    }

    static String getUrl(GenericWebApplicationContext app) {
        String contextPath;
        String sslEnabled;
        String port = app.getEnvironment().getProperty("server.port");
        if (port == null) {
            port = "8080";
        }
        String proto = (sslEnabled = app.getEnvironment().getProperty("server.ssl.enabled")) != null && sslEnabled.equals("true") ? "https" : "http";
        String host = proto + "://localhost:" + port;
        Object path = "/";
        String vaadinServletMapping = RootMappedCondition.getUrlMapping((Environment)app.getEnvironment());
        ServletContext servletContext = app.getServletContext();
        if (servletContext != null && (contextPath = servletContext.getContextPath()) != null && !contextPath.isEmpty()) {
            path = contextPath + "/";
        }
        if (vaadinServletMapping != null && !vaadinServletMapping.isEmpty()) {
            if (vaadinServletMapping.startsWith("/")) {
                vaadinServletMapping = vaadinServletMapping.substring(1);
            }
            if (vaadinServletMapping.endsWith("*")) {
                vaadinServletMapping = vaadinServletMapping.substring(0, vaadinServletMapping.length() - 1);
            }
            path = (String)path + vaadinServletMapping;
        }
        return host + (String)path;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeBrowserLauncher.class);
    }
}

