/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.internal.NetworkUtil;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public class SpringDevToolsPortHandler
implements EnvironmentPostProcessor {
    private static final String SPRING_DEVTOOLS_LIVERELOAD_PORT = "spring.devtools.livereload.port";
    private static final String SPRING_DEVTOOLS_LIVERELOAD_ENABLED = "spring.devtools.livereload.enabled";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        boolean liveReloadEnabled = (Boolean)environment.getProperty(SPRING_DEVTOOLS_LIVERELOAD_ENABLED, Boolean.class, (Object)true);
        if (!liveReloadEnabled) {
            return;
        }
        if (environment.getProperty(SPRING_DEVTOOLS_LIVERELOAD_PORT) == null) {
            int reloadPort = 35729;
            if (!NetworkUtil.isFreePort((int)reloadPort)) {
                reloadPort = NetworkUtil.getFreePort();
            }
            System.setProperty(SPRING_DEVTOOLS_LIVERELOAD_PORT, "" + reloadPort);
        }
    }
}

