/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.server.VaadinSession;
import java.util.Objects;
import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.context.SecurityContextImpl;

public final class VaadinAwareSecurityContextHolderStrategy
implements SecurityContextHolderStrategy {
    private final ThreadLocal<SecurityContext> contextHolder = new ThreadLocal();

    public void clearContext() {
        this.contextHolder.remove();
    }

    @NonNull
    public SecurityContext getContext() {
        SecurityContext context = this.getFromVaadinSession().orElseGet(this.contextHolder::get);
        if (context == null) {
            context = this.createEmptyContext();
            this.contextHolder.set(context);
        }
        return context;
    }

    @NonNull
    private Optional<SecurityContext> getFromVaadinSession() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null || session.getSession() == null) {
            return Optional.empty();
        }
        try {
            Object securityContext = session.getSession().getAttribute("SPRING_SECURITY_CONTEXT");
            if (securityContext instanceof SecurityContext) {
                return Optional.of((SecurityContext)securityContext);
            }
            return Optional.empty();
        }
        catch (IllegalStateException ignored) {
            return Optional.empty();
        }
    }

    public void setContext(@NonNull SecurityContext securityContext) {
        this.contextHolder.set(Objects.requireNonNull(securityContext));
    }

    @NonNull
    public SecurityContext createEmptyContext() {
        return new SecurityContextImpl();
    }
}

