/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.spring.security.RequestUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.DefaultRedirectStrategy;

public class UidlRedirectStrategy
extends DefaultRedirectStrategy {
    private final RequestUtil requestUtil;

    public UidlRedirectStrategy(RequestUtil requestUtil) {
        this.requestUtil = requestUtil;
    }

    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (this.requestUtil.isFrameworkInternalRequest(request)) {
            UI ui = UI.getCurrent();
            if (ui != null) {
                ui.getPage().setLocation(url);
            } else {
                LoggerFactory.getLogger(UidlRedirectStrategy.class).warn("A redirect to {} was request during a Vaadin request, but it was not possible to get the UI instance to perform the action.", (Object)url);
            }
        } else {
            super.sendRedirect(request, response, url);
        }
    }
}

