/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.spring.AuthenticationUtil;
import java.security.Principal;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;

public class SpringViewAccessChecker
extends ViewAccessChecker {
    public SpringViewAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        super(accessAnnotationChecker);
    }

    protected Principal getPrincipal(VaadinRequest request) {
        boolean isWebsocketPush = SpringViewAccessChecker.isWebsocketPush(request);
        if (request == null || isWebsocketPush && request.getUserPrincipal() == null) {
            return AuthenticationUtil.getSecurityHolderAuthentication();
        }
        return request.getUserPrincipal();
    }

    protected Function<String, Boolean> getRolesChecker(VaadinRequest request) {
        boolean isWebsocketPush = SpringViewAccessChecker.isWebsocketPush(request);
        if (request == null || isWebsocketPush) {
            AtomicReference roleCheckerHolder = new AtomicReference();
            Runnable roleCheckerLookup = () -> roleCheckerHolder.set(AuthenticationUtil.getSecurityHolderRoleChecker());
            Authentication authentication = AuthenticationUtil.getSecurityHolderAuthentication();
            if (authentication == null && isWebsocketPush && request.getUserPrincipal() instanceof Authentication) {
                roleCheckerLookup = new DelegatingSecurityContextRunnable(roleCheckerLookup, (SecurityContext)new SecurityContextImpl((Authentication)request.getUserPrincipal()));
            }
            roleCheckerLookup.run();
            return (Function)roleCheckerHolder.get();
        }
        return arg_0 -> ((VaadinRequest)request).isUserInRole(arg_0);
    }

    private static boolean isWebsocketPush(VaadinRequest request) {
        return request != null && HandlerHelper.isRequestType((VaadinRequest)request, (HandlerHelper.RequestType)HandlerHelper.RequestType.PUSH) && "websocket".equals(request.getHeader("X-Atmosphere-Transport"));
    }
}

